/*
 * Decompiled with CFR 0.152.
 */
package cn.easygd.dynaguard.config;

import cn.easygd.dynaguard.ValidationChainInit;
import cn.easygd.dynaguard.ValidationMethodInterceptor;
import cn.easygd.dynaguard.config.GlobalBeanRegister;
import cn.easygd.dynaguard.config.ValidationChainPropertyAutoConfiguration;
import cn.easygd.dynaguard.config.ValidationMethodCondition;
import cn.easygd.dynaguard.core.chain.ValidationChainManager;
import cn.easygd.dynaguard.core.guard.GuardManager;
import cn.easygd.dynaguard.domain.config.ValidationChainConfig;
import org.springframework.aop.framework.autoproxy.BeanNameAutoProxyCreator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={ValidationChainPropertyAutoConfiguration.class})
public class ValidationChainAutoConfig {
    @Bean(value={"validationChainManager"})
    public ValidationChainManager validationChainManager(ValidationChainConfig validationChainConfig) {
        ValidationChainManager manager = ValidationChainManager.getInstance();
        manager.setConfig(validationChainConfig);
        return manager;
    }

    @Bean(value={"guardManager"})
    public GuardManager guardManager() {
        return GuardManager.getInstance();
    }

    @Bean
    public GlobalBeanRegister globalBeanRegister() {
        return new GlobalBeanRegister();
    }

    @Bean
    @Conditional(value={ValidationMethodCondition.class})
    public BeanNameAutoProxyCreator proxyCreator(ValidationChainConfig validationChainConfig, ValidationMethodInterceptor validationMethodInterceptor) {
        BeanNameAutoProxyCreator creator = new BeanNameAutoProxyCreator();
        creator.setBeanNames(validationChainConfig.getValidationMethodList().toArray(new String[0]));
        creator.setInterceptorNames(new String[]{"validationMethodInterceptor"});
        creator.setProxyTargetClass(true);
        return creator;
    }

    @Bean(value={"validationMethodInterceptor"})
    @Conditional(value={ValidationMethodCondition.class})
    public ValidationMethodInterceptor validationMethodInterceptor(ValidationChainManager validationChainManager) {
        ValidationMethodInterceptor validationMethodInterceptor = new ValidationMethodInterceptor();
        validationMethodInterceptor.setValidationChainManager(validationChainManager);
        return validationMethodInterceptor;
    }

    @Bean
    public ValidationChainInit validationChainInit(ValidationChainManager validationChainManager, GuardManager guardManager) {
        ValidationChainInit init = new ValidationChainInit();
        init.setValidationChainManager(validationChainManager);
        init.setCounterGuardManager(guardManager);
        return init;
    }
}

