/*
 * Decompiled with CFR 0.152.
 */
package cn.easygd.dynaguard;

import cn.easygd.dynaguard.core.chain.ValidationChainManager;
import cn.easygd.dynaguard.core.guard.GuardManager;
import cn.easygd.dynaguard.core.guard.ValidationGuard;
import cn.easygd.dynaguard.core.guard.counter.CounterGuard;
import cn.easygd.dynaguard.core.guard.interceptrate.InterceptRateGuard;
import cn.easygd.dynaguard.core.guard.interceptrate.LocalInterceptRateGuard;
import cn.easygd.dynaguard.core.metrics.BizValidationStatistics;
import cn.easygd.dynaguard.core.metrics.LocalBizValidationStatistics;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class ValidationChainInit
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger log = LoggerFactory.getLogger(ValidationChainInit.class);
    private static final String DEFAULT_STATISTICS_BEAN_NAME = "localBizValidationStatistics";
    private static final String DEFAULT_INTERCEPT_BEAN_NAME = "localInterceptRateGuard";
    private ValidationChainManager validationChainManager;
    private GuardManager guardManager;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        ApplicationContext applicationContext = event.getApplicationContext();
        log.info("validation chain load chain start");
        this.validationChainManager.init();
        this.validationChainManager.loadChain();
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)applicationContext.getAutowireCapableBeanFactory();
        Map statisticsBeans = applicationContext.getBeansOfType(BizValidationStatistics.class);
        if (MapUtils.isEmpty((Map)statisticsBeans)) {
            beanFactory.registerSingleton(DEFAULT_STATISTICS_BEAN_NAME, (Object)LocalBizValidationStatistics.getInstance());
        }
        Map counterGuardBeans = applicationContext.getBeansOfType(CounterGuard.class);
        counterGuardBeans.forEach((k, v) -> this.guardManager.register((ValidationGuard)v));
        Map interceptRateGuardBeans = applicationContext.getBeansOfType(InterceptRateGuard.class);
        interceptRateGuardBeans.forEach((k, v) -> this.guardManager.register((ValidationGuard)v));
        boolean isContainsGlobalInterceptRateGuard = interceptRateGuardBeans.values().stream().anyMatch(v -> CollectionUtils.isEmpty((Collection)v.chainId()));
        if (!isContainsGlobalInterceptRateGuard) {
            LocalInterceptRateGuard localInterceptRateGuard = new LocalInterceptRateGuard();
            localInterceptRateGuard.setBizValidationStatistics((BizValidationStatistics)applicationContext.getBean(BizValidationStatistics.class));
            beanFactory.registerSingleton(DEFAULT_INTERCEPT_BEAN_NAME, (Object)localInterceptRateGuard);
        }
        log.info("validation chain load chain end");
    }

    public void setValidationChainManager(ValidationChainManager validationChainManager) {
        this.validationChainManager = validationChainManager;
    }

    public void setCounterGuardManager(GuardManager guardManager) {
        this.guardManager = guardManager;
    }
}

