/*
 * Decompiled with CFR 0.152.
 */
package cn.easyes.core.toolkit;

import cn.easyes.core.toolkit.Tree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TreeBuilder {
    private List<? extends Tree> rootList;
    private List<? extends Tree> bodyList;

    public TreeBuilder(List<? extends Tree> rootList, List<? extends Tree> bodyList) {
        this.rootList = rootList;
        this.bodyList = bodyList;
    }

    public List<? extends Tree> build() {
        HashMap filterOperated = new HashMap(this.rootList.size() + this.bodyList.size());
        this.rootList.forEach(root -> this.setChildren((Tree)root, filterOperated));
        return this.rootList;
    }

    private void setChildren(Tree root, Map<String, String> filterOperated) {
        ArrayList children = new ArrayList();
        this.bodyList.stream().filter(body -> !filterOperated.containsKey(body.getId())).filter(body -> Objects.equals(root.getId(), body.getParentId())).forEach(body -> {
            filterOperated.put(body.getId(), root.getId());
            children.add(body);
            this.setChildren((Tree)body, filterOperated);
        });
        root.setChildren(children);
    }
}

