/*
 * Decompiled with CFR 0.152.
 */
package cn.easyes.core.core;

import cn.easyes.common.constants.BaseEsConstants;
import cn.easyes.common.enums.AggregationTypeEnum;
import cn.easyes.common.enums.EsQueryTypeEnum;
import cn.easyes.common.utils.ArrayUtils;
import cn.easyes.common.utils.CollectionUtils;
import cn.easyes.common.utils.ExceptionUtils;
import cn.easyes.common.utils.MyOptional;
import cn.easyes.common.utils.StringUtils;
import cn.easyes.core.biz.AggregationParam;
import cn.easyes.core.biz.BaseSortParam;
import cn.easyes.core.biz.EntityInfo;
import cn.easyes.core.biz.HighLightParam;
import cn.easyes.core.biz.Param;
import cn.easyes.core.cache.GlobalConfigCache;
import cn.easyes.core.core.Wrapper;
import cn.easyes.core.toolkit.EntityInfoHelper;
import cn.easyes.core.toolkit.FieldUtils;
import cn.easyes.core.toolkit.Tree;
import cn.easyes.core.toolkit.TreeBuilder;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.GeoDistanceQueryBuilder;
import org.elasticsearch.index.query.GeoPolygonQueryBuilder;
import org.elasticsearch.index.query.MatchPhrasePrefixQueryBuilder;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.join.query.HasChildQueryBuilder;
import org.elasticsearch.join.query.HasParentQueryBuilder;
import org.elasticsearch.join.query.ParentIdQueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.collapse.CollapseBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.GeoDistanceSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;

public class WrapperProcessor {
    public static SearchSourceBuilder buildSearchSourceBuilder(Wrapper<?> wrapper, Class<?> entityClass) {
        BoolQueryBuilder boolQueryBuilder = WrapperProcessor.initBoolQueryBuilder(wrapper.paramQueue, entityClass);
        SearchSourceBuilder searchSourceBuilder = WrapperProcessor.initSearchSourceBuilder(wrapper, entityClass);
        searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        return searchSourceBuilder;
    }

    public static BoolQueryBuilder initBoolQueryBuilder(List<Param> paramList, Class<?> entityClass) {
        List rootList = paramList.stream().filter(i -> Objects.isNull(i.getParentId())).collect(Collectors.toList());
        TreeBuilder treeBuilder = new TreeBuilder(rootList, paramList);
        List<? extends Tree> tree = treeBuilder.build();
        BoolQueryBuilder rootBool = QueryBuilders.boolQuery();
        return WrapperProcessor.getBool(tree, rootBool, EntityInfoHelper.getEntityInfo(entityClass), null);
    }

    private static void initBool(BoolQueryBuilder bool, Param param, EntityInfo entityInfo, Map<String, String> mappingColumnMap, Map<String, String> fieldTypeMap) {
        List<? extends Tree> children = param.getChildren();
        switch (param.getQueryTypeEnum()) {
            case OR: 
            case NOT: 
            case FILTER: {
                break;
            }
            case TERM: {
                String realField = FieldUtils.getRealFieldAndSuffix(param.getColumn(), fieldTypeMap, mappingColumnMap);
                AbstractQueryBuilder queryBuilder = QueryBuilders.termQuery((String)realField, (Object)param.getVal()).boost(param.getBoost().floatValue());
                WrapperProcessor.setBool(bool, (QueryBuilder)queryBuilder, param.getPrevQueryType());
                break;
            }
            case MATCH: {
                String realField = FieldUtils.getRealField(param.getColumn(), mappingColumnMap);
                AbstractQueryBuilder queryBuilder = QueryBuilders.matchQuery((String)realField, (Object)param.getVal()).boost(param.getBoost().floatValue());
                WrapperProcessor.setBool(bool, (QueryBuilder)queryBuilder, param.getPrevQueryType());
                break;
            }
            case MATCH_PHRASE: {
                String realField = FieldUtils.getRealField(param.getColumn(), mappingColumnMap);
                AbstractQueryBuilder queryBuilder = QueryBuilders.matchPhraseQuery((String)realField, (Object)param.getVal()).boost(param.getBoost().floatValue());
                WrapperProcessor.setBool(bool, (QueryBuilder)queryBuilder, param.getPrevQueryType());
                break;
            }
            case MATCH_PHRASE_PREFIX: {
                String realField = FieldUtils.getRealField(param.getColumn(), mappingColumnMap);
                MatchPhrasePrefixQueryBuilder queryBuilder = ((MatchPhrasePrefixQueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)realField, (Object)param.getVal()).boost(param.getBoost().floatValue())).maxExpansions(((Integer)param.getExt1()).intValue());
                WrapperProcessor.setBool(bool, (QueryBuilder)queryBuilder, param.getPrevQueryType());
                break;
            }
            case MULTI_MATCH: {
                String[] realFields = FieldUtils.getRealFields(param.getColumns(), mappingColumnMap);
                MultiMatchQueryBuilder queryBuilder = QueryBuilders.multiMatchQuery((Object)param.getVal(), (String[])realFields).operator((Operator)param.getExt1()).minimumShouldMatch(String.valueOf(param.getExt2()));
                WrapperProcessor.setBool(bool, (QueryBuilder)queryBuilder, param.getPrevQueryType());
                break;
            }
            case MATCH_ALL: {
                AbstractQueryBuilder queryBuilder = QueryBuilders.matchAllQuery().boost(param.getBoost().floatValue());
                WrapperProcessor.setBool(bool, (QueryBuilder)queryBuilder, param.getPrevQueryType());
                break;
            }
            case QUERY_STRING: {
                String realField = FieldUtils.getRealFieldAndSuffix(param.getColumn(), fieldTypeMap, mappingColumnMap);
                AbstractQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)realField).boost(param.getBoost().floatValue());
                WrapperProcessor.setBool(bool, (QueryBuilder)queryBuilder, param.getPrevQueryType());
                break;
            }
            case PREFIX: {
                String realField = FieldUtils.getRealField(param.getColumn(), mappingColumnMap);
                AbstractQueryBuilder queryBuilder = QueryBuilders.prefixQuery((String)realField, (String)((String)param.getVal())).boost(param.getBoost().floatValue());
                WrapperProcessor.setBool(bool, (QueryBuilder)queryBuilder, param.getPrevQueryType());
                break;
            }
            case GT: {
                String realField = FieldUtils.getRealFieldAndSuffix(param.getColumn(), fieldTypeMap, mappingColumnMap);
                RangeQueryBuilder rangeBuilder = (RangeQueryBuilder)QueryBuilders.rangeQuery((String)realField).gt(param.getVal()).boost(param.getBoost().floatValue());
                Optional.ofNullable(param.getExt1()).ifPresent(ext1 -> rangeBuilder.timeZone(((ZoneId)ext1).getId()));
                Optional.ofNullable(param.getExt2()).ifPresent(ext2 -> rangeBuilder.format(ext2.toString()));
                WrapperProcessor.setBool(bool, (QueryBuilder)rangeBuilder, param.getPrevQueryType());
                break;
            }
            case GE: {
                String realField = FieldUtils.getRealFieldAndSuffix(param.getColumn(), fieldTypeMap, mappingColumnMap);
                RangeQueryBuilder rangeBuilder = (RangeQueryBuilder)QueryBuilders.rangeQuery((String)realField).gte(param.getVal()).boost(param.getBoost().floatValue());
                Optional.ofNullable(param.getExt1()).ifPresent(ext1 -> rangeBuilder.timeZone(((ZoneId)ext1).getId()));
                Optional.ofNullable(param.getExt2()).ifPresent(ext2 -> rangeBuilder.format(ext2.toString()));
                WrapperProcessor.setBool(bool, (QueryBuilder)rangeBuilder, param.getPrevQueryType());
                break;
            }
            case LT: {
                String realField = FieldUtils.getRealFieldAndSuffix(param.getColumn(), fieldTypeMap, mappingColumnMap);
                RangeQueryBuilder rangeBuilder = (RangeQueryBuilder)QueryBuilders.rangeQuery((String)realField).lt(param.getVal()).boost(param.getBoost().floatValue());
                Optional.ofNullable(param.getExt1()).ifPresent(ext1 -> rangeBuilder.timeZone(((ZoneId)ext1).getId()));
                Optional.ofNullable(param.getExt2()).ifPresent(ext2 -> rangeBuilder.format(ext2.toString()));
                WrapperProcessor.setBool(bool, (QueryBuilder)rangeBuilder, param.getPrevQueryType());
                break;
            }
            case LE: {
                String realField = FieldUtils.getRealFieldAndSuffix(param.getColumn(), fieldTypeMap, mappingColumnMap);
                RangeQueryBuilder rangeBuilder = (RangeQueryBuilder)QueryBuilders.rangeQuery((String)realField).lte(param.getVal()).boost(param.getBoost().floatValue());
                Optional.ofNullable(param.getExt1()).ifPresent(ext1 -> rangeBuilder.timeZone(((ZoneId)ext1).getId()));
                Optional.ofNullable(param.getExt2()).ifPresent(ext2 -> rangeBuilder.format(ext2.toString()));
                WrapperProcessor.setBool(bool, (QueryBuilder)rangeBuilder, param.getPrevQueryType());
                break;
            }
            case BETWEEN: {
                String realField = FieldUtils.getRealFieldAndSuffix(param.getColumn(), fieldTypeMap, mappingColumnMap);
                RangeQueryBuilder rangeBuilder = (RangeQueryBuilder)QueryBuilders.rangeQuery((String)realField).gte(param.getExt1()).lte(param.getExt2()).boost(param.getBoost().floatValue());
                Optional.ofNullable(param.getExt3()).ifPresent(ext3 -> rangeBuilder.timeZone(((ZoneId)ext3).getId()));
                Optional.ofNullable(param.getExt4()).ifPresent(ext4 -> rangeBuilder.format(ext4.toString()));
                WrapperProcessor.setBool(bool, (QueryBuilder)rangeBuilder, param.getPrevQueryType());
                break;
            }
            case WILDCARD: {
                String realField = FieldUtils.getRealFieldAndSuffix(param.getColumn(), fieldTypeMap, mappingColumnMap);
                WildcardQueryBuilder queryBuilder = QueryBuilders.wildcardQuery((String)realField, (String)param.getVal().toString());
                WrapperProcessor.setBool(bool, (QueryBuilder)queryBuilder, param.getPrevQueryType());
                break;
            }
            case TERMS: {
                String realField = FieldUtils.getRealFieldAndSuffix(param.getColumn(), fieldTypeMap, mappingColumnMap);
                TermsQueryBuilder queryBuilder = QueryBuilders.termsQuery((String)realField, (Collection)((Collection)param.getVal()));
                WrapperProcessor.setBool(bool, (QueryBuilder)queryBuilder, param.getPrevQueryType());
                break;
            }
            case EXISTS: {
                String realField = FieldUtils.getRealField(param.getColumn(), mappingColumnMap);
                AbstractQueryBuilder queryBuilder = QueryBuilders.existsQuery((String)realField).boost(param.getBoost().floatValue());
                WrapperProcessor.setBool(bool, (QueryBuilder)queryBuilder, param.getPrevQueryType());
                break;
            }
            case GEO_BOUNDING_BOX: {
                String realField = FieldUtils.getRealField(param.getColumn(), mappingColumnMap);
                AbstractQueryBuilder queryBuilder = QueryBuilders.geoBoundingBoxQuery((String)realField).setCorners((GeoPoint)param.getExt1(), (GeoPoint)param.getExt2()).boost(param.getBoost().floatValue());
                WrapperProcessor.setBool(bool, (QueryBuilder)queryBuilder, param.getPrevQueryType());
                break;
            }
            case GEO_DISTANCE: {
                String realField = FieldUtils.getRealField(param.getColumn(), mappingColumnMap);
                GeoDistanceQueryBuilder geoDistanceBuilder = (GeoDistanceQueryBuilder)QueryBuilders.geoDistanceQuery((String)realField).point((GeoPoint)param.getExt2()).boost(param.getBoost().floatValue());
                MyOptional.ofNullable((Object)param.getExt1()).ifPresent(ext1 -> geoDistanceBuilder.distance(((Double)param.getVal()).doubleValue(), (DistanceUnit)ext1), () -> geoDistanceBuilder.distance((String)param.getVal()));
                GeoDistanceQueryBuilder queryBuilder = geoDistanceBuilder;
                WrapperProcessor.setBool(bool, (QueryBuilder)queryBuilder, param.getPrevQueryType());
                break;
            }
            case GEO_POLYGON: {
                String realField = FieldUtils.getRealField(param.getColumn(), mappingColumnMap);
                GeoPolygonQueryBuilder queryBuilder = QueryBuilders.geoPolygonQuery((String)realField, (List)((List)param.getVal()));
                WrapperProcessor.setBool(bool, (QueryBuilder)queryBuilder, param.getPrevQueryType());
                break;
            }
            case GEO_SHAPE_ID: {
                String realField = FieldUtils.getRealField(param.getColumn(), mappingColumnMap);
                AbstractQueryBuilder queryBuilder = QueryBuilders.geoShapeQuery((String)realField, (String)param.getVal().toString()).boost(param.getBoost().floatValue());
                WrapperProcessor.setBool(bool, (QueryBuilder)queryBuilder, param.getPrevQueryType());
                break;
            }
            case GEO_SHAPE: {
                String realField = FieldUtils.getRealField(param.getColumn(), mappingColumnMap);
                AbstractQueryBuilder queryBuilder = QueryBuilders.geoShapeQuery((String)realField, (Geometry)((Geometry)param.getVal())).relation((ShapeRelation)param.getExt1()).boost(param.getBoost().floatValue());
                WrapperProcessor.setBool(bool, (QueryBuilder)queryBuilder, param.getPrevQueryType());
                break;
            }
            case HAS_CHILD: {
                String realField = FieldUtils.getRealField(param.getColumn(), mappingColumnMap);
                HasChildQueryBuilder queryBuilder = new HasChildQueryBuilder(param.getExt1().toString(), (QueryBuilder)QueryBuilders.matchQuery((String)(param.getExt1().toString() + "." + realField), (Object)param.getVal()).boost(param.getBoost().floatValue()), (ScoreMode)param.getExt2());
                WrapperProcessor.setBool(bool, (QueryBuilder)queryBuilder, param.getPrevQueryType());
                break;
            }
            case HAS_PARENT: {
                String realField = FieldUtils.getRealField(param.getColumn(), mappingColumnMap);
                HasParentQueryBuilder queryBuilder = new HasParentQueryBuilder(param.getExt1().toString(), (QueryBuilder)QueryBuilders.matchQuery((String)(param.getExt1().toString() + "." + realField), (Object)param.getVal()).boost(param.getBoost().floatValue()), ((Boolean)param.getExt2()).booleanValue());
                WrapperProcessor.setBool(bool, (QueryBuilder)queryBuilder, param.getPrevQueryType());
                break;
            }
            case PARENT_ID: {
                String realField = FieldUtils.getRealField(param.getColumn(), mappingColumnMap);
                ParentIdQueryBuilder queryBuilder = new ParentIdQueryBuilder(realField, param.getVal().toString());
                WrapperProcessor.setBool(bool, (QueryBuilder)queryBuilder, param.getPrevQueryType());
                break;
            }
            case NESTED_AND: 
            case NESTED_FILTER: 
            case NESTED_NOT: 
            case NESTED_OR: {
                BoolQueryBuilder queryBuilder = WrapperProcessor.getBool(children, QueryBuilders.boolQuery(), entityInfo, null);
                WrapperProcessor.setBool(bool, (QueryBuilder)queryBuilder, param.getPrevQueryType());
                break;
            }
            case NESTED: {
                String realField = FieldUtils.getRealField(param.getColumn(), mappingColumnMap);
                String[] split = param.getColumn().split("\\.");
                BoolQueryBuilder queryBuilder = WrapperProcessor.getBool(children, QueryBuilders.boolQuery(), entityInfo, split[split.length - 1]);
                queryBuilder = QueryBuilders.nestedQuery((String)realField, (QueryBuilder)queryBuilder, (ScoreMode)((ScoreMode)param.getVal()));
                WrapperProcessor.setBool(bool, (QueryBuilder)queryBuilder, param.getPrevQueryType());
                break;
            }
            default: {
                throw ExceptionUtils.eee((String)"\u975e\u6cd5\u53c2\u6570\u7c7b\u578b", (Object[])new Object[0]);
            }
        }
    }

    private static void setBool(BoolQueryBuilder bool, QueryBuilder queryBuilder, EsQueryTypeEnum parentType) {
        if (EsQueryTypeEnum.NESTED_AND.equals((Object)parentType)) {
            bool.must(queryBuilder);
        } else if (EsQueryTypeEnum.NESTED_OR.equals((Object)parentType)) {
            bool.should(queryBuilder);
        } else if (EsQueryTypeEnum.NESTED_FILTER.equals((Object)parentType)) {
            bool.filter(queryBuilder);
        } else if (EsQueryTypeEnum.NESTED_NOT.equals((Object)parentType)) {
            bool.mustNot(queryBuilder);
        } else {
            bool.must(queryBuilder);
        }
    }

    private static BoolQueryBuilder getBool(List<Param> paramList, BoolQueryBuilder builder, EntityInfo entityInfo, String path) {
        Map fieldTypeMap;
        Map mappingColumnMap;
        if (CollectionUtils.isEmpty(paramList)) {
            return builder;
        }
        if (StringUtils.isNotBlank((CharSequence)path)) {
            Class<?> clazz = entityInfo.getPathClassMap().get(path);
            mappingColumnMap = Optional.ofNullable(entityInfo.getNestedClassMappingColumnMap().get(clazz)).orElse(new HashMap(0));
            fieldTypeMap = Optional.ofNullable(entityInfo.getNestedClassFieldTypeMap().get(clazz)).orElse(new HashMap(0));
        } else {
            mappingColumnMap = entityInfo.getMappingColumnMap();
            fieldTypeMap = entityInfo.getFieldTypeMap();
        }
        paramList.forEach(param -> WrapperProcessor.initBool(builder, param, entityInfo, mappingColumnMap, fieldTypeMap));
        return builder;
    }

    private static SearchSourceBuilder initSearchSourceBuilder(Wrapper<?> wrapper, Class<?> entityClass) {
        EntityInfo entityInfo = EntityInfoHelper.getEntityInfo(entityClass);
        Map<String, String> mappingColumnMap = entityInfo.getMappingColumnMap();
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        WrapperProcessor.setHighLight(entityInfo.getHighLightParams(), searchSourceBuilder);
        WrapperProcessor.setSort(wrapper, mappingColumnMap, searchSourceBuilder);
        WrapperProcessor.setFetchSource(wrapper, mappingColumnMap, searchSourceBuilder);
        WrapperProcessor.setAggregations(wrapper, mappingColumnMap, searchSourceBuilder);
        Optional.ofNullable(wrapper.from).ifPresent(arg_0 -> ((SearchSourceBuilder)searchSourceBuilder).from(arg_0));
        MyOptional.ofNullable((Object)wrapper.size).ifPresent(arg_0 -> ((SearchSourceBuilder)searchSourceBuilder).size(arg_0), (Object)BaseEsConstants.DEFAULT_SIZE);
        if (GlobalConfigCache.getGlobalConfig().getDbConfig().isEnableTrackTotalHits()) {
            searchSourceBuilder.trackTotalHits(Boolean.TRUE.booleanValue());
        }
        return searchSourceBuilder;
    }

    public static boolean includeId(String idField, Wrapper<?> wrapper) {
        if (ArrayUtils.isEmpty((Object[])wrapper.include) && ArrayUtils.isEmpty((Object[])wrapper.exclude)) {
            return true;
        }
        if (ArrayUtils.isNotEmpty((Object[])wrapper.include) && Arrays.asList(wrapper.include).contains(idField)) {
            return true;
        }
        return ArrayUtils.isNotEmpty((Object[])wrapper.exclude) && !Arrays.asList(wrapper.exclude).contains(idField);
    }

    private static void setFetchSource(Wrapper<?> wrapper, Map<String, String> mappingColumnMap, SearchSourceBuilder searchSourceBuilder) {
        if (ArrayUtils.isEmpty((Object[])wrapper.include) && ArrayUtils.isEmpty((Object[])wrapper.exclude)) {
            return;
        }
        String[] includes = FieldUtils.getRealFields(wrapper.include, mappingColumnMap);
        String[] excludes = FieldUtils.getRealFields(wrapper.exclude, mappingColumnMap);
        searchSourceBuilder.fetchSource(includes, excludes);
    }

    private static void setHighLight(List<HighLightParam> highLightParams, SearchSourceBuilder searchSourceBuilder) {
        if (CollectionUtils.isEmpty(highLightParams)) {
            return;
        }
        HighlightBuilder highlightBuilder = new HighlightBuilder();
        highLightParams.forEach(highLightParam -> {
            if (StringUtils.isNotBlank((CharSequence)highLightParam.getHighLightField())) {
                HighlightBuilder.Field field = new HighlightBuilder.Field(highLightParam.getHighLightField());
                field.highlighterType(highLightParam.getHighLightType().getValue());
                highlightBuilder.field(field);
                highlightBuilder.fragmentSize(Integer.valueOf(highLightParam.getFragmentSize()));
                highlightBuilder.preTags(new String[]{highLightParam.getPreTag()});
                highlightBuilder.postTags(new String[]{highLightParam.getPostTag()});
            }
        });
        searchSourceBuilder.highlighter(highlightBuilder);
    }

    private static void setSort(Wrapper<?> wrapper, Map<String, String> mappingColumnMap, SearchSourceBuilder searchSourceBuilder) {
        if (CollectionUtils.isNotEmpty(wrapper.baseSortParams)) {
            wrapper.baseSortParams.forEach(baseSortParam -> {
                String realField = Objects.isNull(baseSortParam.getSortField()) ? null : FieldUtils.getRealField(baseSortParam.getSortField(), mappingColumnMap);
                SortBuilder<?> sortBuilder = WrapperProcessor.getSortBuilder(realField, baseSortParam);
                Optional.ofNullable(sortBuilder).ifPresent(arg_0 -> ((SearchSourceBuilder)searchSourceBuilder).sort(arg_0));
            });
        }
        if (CollectionUtils.isNotEmpty(wrapper.orderByParams)) {
            wrapper.orderByParams.forEach(orderByParam -> {
                FieldSortBuilder fieldSortBuilder = new FieldSortBuilder(orderByParam.getOrder());
                if (SortOrder.ASC.toString().equalsIgnoreCase(orderByParam.getSort())) {
                    fieldSortBuilder.order(SortOrder.ASC);
                }
                if (SortOrder.DESC.toString().equalsIgnoreCase(orderByParam.getSort())) {
                    fieldSortBuilder.order(SortOrder.DESC);
                }
                searchSourceBuilder.sort((SortBuilder)fieldSortBuilder);
            });
        }
    }

    private static SortBuilder<?> getSortBuilder(String realField, BaseSortParam baseSortParam) {
        switch (baseSortParam.getOrderTypeEnum()) {
            case FIELD: {
                return SortBuilders.fieldSort((String)realField).order(baseSortParam.getSortOrder());
            }
            case SCORE: {
                return SortBuilders.scoreSort().order(baseSortParam.getSortOrder());
            }
            case GEO: {
                return ((GeoDistanceSortBuilder)SortBuilders.geoDistanceSort((String)realField, (GeoPoint[])baseSortParam.getGeoPoints()).order(baseSortParam.getSortOrder())).geoDistance(baseSortParam.getGeoDistance()).unit(baseSortParam.getUnit());
            }
            case CUSTOMIZE: {
                return baseSortParam.getSortBuilder();
            }
        }
        return null;
    }

    private static void setAggregations(Wrapper<?> wrapper, Map<String, String> mappingColumnMap, SearchSourceBuilder searchSourceBuilder) {
        Optional.ofNullable(wrapper.distinctField).ifPresent(distinctField -> {
            String realField = FieldUtils.getRealField(distinctField, mappingColumnMap);
            searchSourceBuilder.collapse(new CollapseBuilder(realField));
            searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.cardinality((String)"repeat_num").field(realField));
        });
        List<AggregationParam> aggregationParamList = wrapper.aggregationParamList;
        if (CollectionUtils.isEmpty(aggregationParamList)) {
            return;
        }
        AggregationBuilder root = null;
        AggregationBuilder cursor = null;
        for (AggregationParam aggParam : aggregationParamList) {
            String realField = FieldUtils.getRealField(aggParam.getField(), mappingColumnMap);
            AggregationBuilder builder = WrapperProcessor.getRealAggregationBuilder(aggParam.getAggregationType(), aggParam.getName(), realField);
            if (aggParam.isEnablePipeline()) {
                if (root == null) {
                    cursor = root = builder;
                    continue;
                }
                cursor.subAggregation(builder);
                if (!(builder instanceof TermsAggregationBuilder)) continue;
                cursor = builder;
                continue;
            }
            searchSourceBuilder.aggregation(builder);
        }
        Optional.ofNullable(root).ifPresent(arg_0 -> ((SearchSourceBuilder)searchSourceBuilder).aggregation(arg_0));
    }

    private static AggregationBuilder getRealAggregationBuilder(AggregationTypeEnum aggType, String name, String realField) {
        ValuesSourceAggregationBuilder aggregationBuilder;
        name = name + aggType.getValue();
        switch (aggType) {
            case AVG: {
                aggregationBuilder = AggregationBuilders.avg((String)name).field(realField);
                break;
            }
            case MIN: {
                aggregationBuilder = AggregationBuilders.min((String)name).field(realField);
                break;
            }
            case MAX: {
                aggregationBuilder = AggregationBuilders.max((String)name).field(realField);
                break;
            }
            case SUM: {
                aggregationBuilder = AggregationBuilders.sum((String)name).field(realField);
                break;
            }
            case TERMS: {
                aggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)name).field(realField)).size(Integer.MAX_VALUE);
                break;
            }
            default: {
                throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u805a\u5408\u7c7b\u578b,\u53c2\u89c1AggregationTypeEnum");
            }
        }
        return aggregationBuilder;
    }
}

