/*
 * Decompiled with CFR 0.152.
 */
package cn.easyes.core.cache;

import cn.easyes.core.config.GlobalConfig;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class GlobalConfigCache {
    private static final Map<Class<?>, GlobalConfig> globalConfigMap = new ConcurrentHashMap(1);

    public static GlobalConfig getGlobalConfig() {
        return Optional.ofNullable(globalConfigMap.get(GlobalConfig.class)).orElseGet(() -> {
            GlobalConfig globalConfig = new GlobalConfig();
            GlobalConfig.DbConfig dbConfig = new GlobalConfig.DbConfig();
            globalConfig.setDbConfig(dbConfig);
            return globalConfig;
        });
    }

    public static void setGlobalConfig(GlobalConfig globalConfig) {
        globalConfigMap.putIfAbsent(GlobalConfig.class, globalConfig);
    }
}

