/*
 * Decompiled with CFR 0.152.
 */
package cn.easyes.common.utils;

import cn.easyes.common.utils.ExceptionUtils;
import cn.easyes.common.utils.LogUtils;
import java.io.IOException;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.core.MainResponse;

public class EsVersionUtil {
    private static final String supportedVersion = "7";

    public static String getJarVersion(RestHighLevelClient restHighLevelClient) {
        String version = restHighLevelClient.getClass().getPackage().getImplementationVersion();
        LogUtils.formatInfo("Elasticsearch jar version:%s", version);
        return version;
    }

    public static String getClientVersion(RestHighLevelClient restHighLevelClient) {
        MainResponse info;
        try {
            info = restHighLevelClient.info(RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String version = info.getVersion().getNumber();
        LogUtils.formatInfo("Elasticsearch client version:%s", version);
        return version;
    }

    public static void verify(RestHighLevelClient restHighLevelClient) {
        String jarVersion = EsVersionUtil.getJarVersion(restHighLevelClient);
        if (!jarVersion.startsWith(supportedVersion)) {
            throw ExceptionUtils.eee("Easy-Es supported elasticsearch jar version is:%s.xx", supportedVersion);
        }
        String clientVersion = EsVersionUtil.getClientVersion(restHighLevelClient);
        if (!clientVersion.startsWith(supportedVersion)) {
            LogUtils.formatWarn("Easy-Es supported elasticsearch client version is:%s.xx", supportedVersion);
        }
        if (!jarVersion.equals(clientVersion)) {
            LogUtils.formatWarn("Elasticsearch clientVersion:%s not equals jarVersion:%s", clientVersion, jarVersion);
        }
    }

    private EsVersionUtil() {
    }
}

