/*
 * Decompiled with CFR 0.152.
 */
package cn.easii.relation;

import cn.easii.relation.AutoRelationAspect;
import cn.easii.relation.EasyDataProviderInitializationConfiguration;
import cn.easii.relation.MapToBeanHandle;
import cn.easii.relation.RelationCache;
import cn.easii.relation.core.DefaultRelationCache;
import cn.easii.relation.core.InjectRelation;
import cn.easii.relation.core.JsonMapToBeanHandle;
import cn.easii.relation.properties.RelationProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Import;

@Configuration
@ComponentScan(value={"cn.easii.relation"})
@Import(value={EasyDataProviderInitializationConfiguration.class})
@EnableAspectJAutoProxy(proxyTargetClass=true)
public class EasyRelationAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={RelationProperties.class})
    @ConfigurationProperties(prefix="easy.relation")
    public RelationProperties relationProperties() {
        return new RelationProperties();
    }

    @Bean
    @ConditionalOnMissingBean(value={RelationCache.class})
    public RelationCache relationCache() {
        return new DefaultRelationCache();
    }

    @Bean
    @ConditionalOnMissingBean(value={MapToBeanHandle.class})
    public MapToBeanHandle mapToBeanHandle() {
        return new JsonMapToBeanHandle();
    }

    @Bean
    public InjectRelation injectRelation(RelationCache relationCache, MapToBeanHandle mapToBeanHandle, RelationProperties relationProperties) {
        return new InjectRelation(relationCache, mapToBeanHandle, relationProperties);
    }

    @Bean
    public AutoRelationAspect autoRelationAspect(InjectRelation injectRelation) {
        return new AutoRelationAspect(injectRelation);
    }
}

