/*
 * Decompiled with CFR 0.152.
 */
package cn.dyaoming.web.advices;

import cn.dyaoming.models.BaseRestModel;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

public class BaseResponseBodyAdvice
implements ResponseBodyAdvice {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private static final Class<? extends Annotation> ANNOTATION_TYPE = RestController.class;

    public boolean supports(MethodParameter returnType, Class converterType) {
        return AnnotatedElementUtils.hasAnnotation((AnnotatedElement)returnType.getContainingClass(), ANNOTATION_TYPE) || returnType.hasMethodAnnotation(ANNOTATION_TYPE);
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        if (body instanceof BaseRestModel) {
            return (BaseRestModel)body;
        }
        if (body instanceof String) {
            HttpHeaders headers = response.getHeaders();
            headers.add("content-type", "application/json;charset=UTF-8");
            try {
                return new ObjectMapper().writeValueAsString((Object)BaseRestModel.success((Object)body));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return BaseRestModel.success((Object)body);
    }
}

