/*
 * Decompiled with CFR 0.152.
 */
package cn.dyaoming.web.advices;

import cn.dyaoming.errors.BaseException;
import cn.dyaoming.errors.BaseRunTimeException;
import cn.dyaoming.models.BaseRestModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class BaseExceptionAdvice {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    @ExceptionHandler(value={Exception.class})
    @Order(value=500000)
    @ResponseBody
    public BaseRestModel handleException(Exception exception) {
        this.log.error("\u7cfb\u7edf\u53d1\u751f\u672a\u5bdf\u89c9\u5f02\u5e38\uff0c\u5f02\u5e38\u5185\u5bb9\uff1a" + exception.getMessage(), (Throwable)exception);
        return BaseRestModel.failed();
    }

    @ExceptionHandler(value={BaseException.class})
    @Order(value=100000)
    @ResponseBody
    public BaseRestModel handleAppBaseException(BaseException baseException) {
        this.log.error("\u7cfb\u7edf\u53d1\u751f\u5f02\u5e38\uff0c\u901a\u8fc7\u63a7\u5236\u5c42\u629b\u5411\u524d\u7aef\u3002", (Throwable)baseException);
        return BaseRestModel.failed((String)baseException.getCode(), (String)baseException.getMessage());
    }

    @ExceptionHandler(value={BaseRunTimeException.class})
    @Order(value=80000)
    @ResponseBody
    public BaseRestModel handleAppRunTimeException(BaseRunTimeException runTimeException) {
        this.log.debug("\u7cfb\u7edf\u53d1\u751f\u8fd0\u884c\u65f6\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + runTimeException.getMessage(), (Throwable)runTimeException);
        return BaseRestModel.failed((String)runTimeException.getCode(), (String)runTimeException.getMessage());
    }
}

