/*
 * Decompiled with CFR 0.152.
 */
package cn.dyaoming.sync.interfaces;

import cn.dyaoming.errors.AppBusyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface SyncLockInterface {
    public static final Logger LOGGER = LoggerFactory.getLogger(SyncLockInterface.class);
    public static final String SET_LOCK_LUA_CODE = "if (redis.call('exists', KEYS[1]) == 0) then redis.call('hset', KEYS[1], ARGV[1], 1); redis.call('pexpire', KEYS[1], ARGV[2]); return 'OK'; end; if (redis.call('hexists', KEYS[1], ARGV[1]) == 1) then local ttl = redis.call('pttl', KEYS[1])redis.call('hincrby', KEYS[1], ARGV[1], 1); redis.call('pexpire', KEYS[1], ARGV[2] + ttl); return 'OK'; end; return 'ERROR';";
    public static final String REMOVE_LOCK_LUA_CODE = "if (redis.call('exists', KEYS[1]) == 0) then return 'OK'; end;if (redis.call('hexists', KEYS[1], ARGV[1]) == 0) then return 'OK';end; local counter = redis.call('hincrby', KEYS[1], ARGV[1], -1); if (counter > 0) then return 'OK'; else redis.call('del', KEYS[1]);  return 'OK'; end; return 'ERROR';";
    public static final String SUCCESS_CODE = "OK";

    public boolean tryLock(Object var1, Object var2, long var3);

    default public void getLock(Object lockKey, Object serial, long expire, long waittime) {
        long startTime = System.currentTimeMillis();
        long stopTime = startTime + waittime * 1000L;
        while (System.currentTimeMillis() <= stopTime) {
            if (this.tryLock(lockKey, serial, expire)) {
                return;
            }
            try {
                long sleepTime = 100L + Double.valueOf(Math.random() * 50.0).longValue();
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                LOGGER.warn("\u7ebf\u7a0b\u4f11\u7720\u5f02\u5e38");
            }
        }
        throw AppBusyException.create((String)"\u83b7\u53d6\u8d44\u6e90\u9501\u8d85\u65f6\uff01");
    }

    public boolean releaseLock(Object var1, Object var2);
}

