/*
 * Decompiled with CFR 0.152.
 */
package cn.dyaoming.sync.aspects;

import cn.dyaoming.errors.AppBusyException;
import cn.dyaoming.sync.annotations.SyncLock;
import cn.dyaoming.sync.interfaces.SyncLockInterface;
import cn.dyaoming.utils.GeneratorKeyUtil;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class SyncLockAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncLockAspect.class);
    @Autowired
    private SyncLockInterface syncLockInterface;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(syncLock)")
    public Object around(ProceedingJoinPoint point, SyncLock syncLock) {
        block7: {
            String strClassName = point.getTarget().getClass().getName();
            String strMethodName = point.getSignature().getName();
            String key = strClassName + strMethodName;
            String serial = GeneratorKeyUtil.getSeral();
            if (this.syncLockInterface.getLock(key, serial, 2L, 2L)) {
                LOGGER.debug("\u5df2\u83b7\u5f97\u9501\uff0c\u8fdb\u884c\u64cd\u4f5c\uff01");
                try {
                    Object object = point.proceed();
                    return object;
                }
                catch (Throwable throwable) {
                    break block7;
                }
            }
            LOGGER.debug("\u672a\u83b7\u5f97\u9501\uff0c\u629b\u51fa\u5f02\u5e38\uff01");
            throw new AppBusyException();
            finally {
                this.syncLockInterface.releaseLock(key, serial);
            }
        }
        return null;
    }
}

