/*
 * Decompiled with CFR 0.152.
 */
package cn.dyaoming.cache;

import cn.dyaoming.cache.CacheKeyGenerator;
import cn.dyaoming.cache.DefaultCacheManager;
import cn.dyaoming.cache.SystemCache;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(value={"cn.dyaoming.utils"})
public class DefaultCacheConfig
extends CachingConfigurerSupport {
    @Value(value="${config.cache.cacheNames:null}")
    private String cacheNames;
    private static final String SEPARATOR = ",";

    @Bean
    public CacheManager cacheManager() {
        DefaultCacheManager cacheManager = new DefaultCacheManager();
        if (this.cacheNames != null) {
            ArrayList<SystemCache> caches = new ArrayList<SystemCache>();
            for (String cacheName : this.cacheNames.split(SEPARATOR)) {
                caches.add(new SystemCache(cacheName));
            }
            cacheManager.setCaches(caches);
        }
        return cacheManager;
    }

    @Bean
    public KeyGenerator keyGenerator() {
        return new CacheKeyGenerator();
    }
}

