/*
 * Decompiled with CFR 0.152.
 */
package cn.dyaoming.cache;

import cn.dyaoming.cache.interfaces.CacheInterface;
import cn.dyaoming.utils.GeneratorKeyUtil;
import cn.dyaoming.utils.SpringUtil;
import cn.dyaoming.utils.StringUtil;
import java.util.concurrent.Callable;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;

public class SystemCache
implements Cache,
InitializingBean {
    @Autowired
    private CacheInterface cacheDao;
    private String name;
    private long timeout;
    private boolean secret;
    private String database;

    public SystemCache() {
    }

    public SystemCache(String name, long timeout, boolean secret) {
        this.setName(name);
        this.setTimeout(timeout);
        this.secret = secret;
        this.setCacheDao((CacheInterface)SpringUtil.getBean((String)"cacheDao"));
    }

    public SystemCache(String name, long timeout, boolean secret, String database) {
        this.setName(name);
        this.setTimeout(timeout);
        this.secret = secret;
        this.setDatabase(database);
        this.setCacheDao((CacheInterface)SpringUtil.getBean((String)"cacheDao"));
        this.cacheDao.init(this.database);
    }

    public Object getNativeCache() {
        return this.cacheDao;
    }

    public Cache.ValueWrapper get(Object key) {
        if (StringUtil.isEmpty((Object)key)) {
            return null;
        }
        String finalKey = key instanceof String ? (String)key : key.toString();
        Object object = this.cacheDao.getCacheData("cache:" + this.getName() + ":" + finalKey);
        return object != null ? new SimpleValueWrapper(object) : null;
    }

    public <T> T get(Object key, Class<T> type) {
        if (StringUtil.isEmpty((Object)key) || null == type) {
            return null;
        }
        Object object = this.cacheDao.getCacheData("cache:" + this.getName() + ":" + key);
        if (type != null && type.isInstance(object) && null != object) {
            return (T)object;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Object key, Callable<T> valueLoader) {
        Cache.ValueWrapper vw = this.get(key);
        if (vw != null) {
            return (T)vw;
        }
        String serial = GeneratorKeyUtil.getSeral();
        try {
            this.cacheDao.getLock("lock:" + key, serial, 2L, 2L);
            vw = this.get(key);
            if (vw != null) {
                Cache.ValueWrapper valueWrapper = vw;
                return (T)valueWrapper;
            }
            T value = valueLoader.call();
            this.put(key, value);
            Cache.ValueWrapper valueWrapper = vw;
            return (T)valueWrapper;
        }
        catch (Exception exception) {
        }
        finally {
            this.cacheDao.releaseLock("lock:" + key, serial);
        }
        return null;
    }

    public void put(Object key, Object value) {
        if (StringUtil.isEmpty((Object)key) || StringUtil.isEmpty((Object)value) || this.timeout == 0L) {
            return;
        }
        this.cacheDao.setCacheObjectData("cache:" + this.getName() + ":" + key, value, this.timeout, this.secret);
    }

    public void evict(Object key) {
        if (!StringUtil.isEmpty((Object)key)) {
            this.cacheDao.deleteRegexCacheData("cache:" + this.getName() + ":" + key);
        }
    }

    public void clear() {
        this.cacheDao.clear();
    }

    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        if (StringUtil.isEmpty((Object)key) || StringUtil.isEmpty((Object)value) || this.timeout == 0L) {
            return null;
        }
        if (this.cacheDao.exists(key)) {
            return this.get(key);
        }
        this.cacheDao.setCacheObjectData("cache:" + this.getName() + ":" + key, value, this.timeout, this.secret);
        return new SimpleValueWrapper(value);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setSecret(String secret) {
        this.secret = "true".equalsIgnoreCase(secret);
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setCacheDao(CacheInterface cacheDao) {
        this.cacheDao = cacheDao;
    }

    public void afterPropertiesSet() throws Exception {
        this.cacheDao.init(this.database);
    }
}

