/*
 * Decompiled with CFR 0.152.
 */
package cn.dyaoming.cache;

import cn.dyaoming.cache.SystemCache;
import java.util.Collection;
import java.util.Collections;
import org.springframework.cache.Cache;
import org.springframework.cache.support.AbstractCacheManager;

public class DefaultCacheManager
extends AbstractCacheManager {
    private String name = "default";
    private long timeout = 300L;
    private boolean secret;
    private String database;
    private static final String SEPARATOR = "#";
    private Collection<? extends Cache> caches = Collections.emptySet();

    public void setName(String name) {
        this.name = name;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setSecret(String secret) {
        this.secret = "true".equalsIgnoreCase(secret);
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setCaches(Collection<? extends Cache> caches) {
        this.caches = caches;
    }

    protected Collection<? extends Cache> loadCaches() {
        return this.caches;
    }

    protected Cache getMissingCache(String name) {
        String thisName = name;
        long thisTimeout = this.timeout;
        boolean thisSecret = this.secret;
        String thisDatabase = this.database;
        if (name.indexOf(SEPARATOR) > 0) {
            String[] arg = name.split(SEPARATOR);
            int thisLength = arg.length;
            thisName = arg[0];
            if (thisLength > 1) {
                thisTimeout = Long.valueOf(arg[1]);
            }
            if (thisLength > 2) {
                thisSecret = "true".equalsIgnoreCase(arg[2]);
            }
            if (thisLength > 3) {
                thisDatabase = arg[3];
            }
        }
        return new SystemCache(thisName, thisTimeout, thisSecret, thisDatabase);
    }
}

