/*
 * Decompiled with CFR 0.152.
 */
package cn.dyaoming.cache.dao;

import cn.dyaoming.cache.dao.RedisBaseImp;
import cn.dyaoming.cache.interfaces.CacheRegexInterface;
import cn.dyaoming.errors.AppDaoException;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.StringUtils;

public class RedisRegexImp
extends RedisBaseImp
implements CacheRegexInterface {
    private static final Logger LOGGER = LogManager.getLogger(RedisRegexImp.class);
    @Autowired
    private RedisTemplate redisTemplate;

    @Override
    public RedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    @Override
    public void setRedisTemplate(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Override
    public Collection<String> getKeys(String pattern) throws AppDaoException {
        Set<String> rv = new HashSet<String>();
        try {
            if (!StringUtils.isEmpty((Object)pattern)) {
                final byte[] finalKey = pattern.toString().getBytes("utf-8");
                rv = (Set)this.redisTemplate.execute((RedisCallback)new RedisCallback<Set<String>>(){

                    public Set<String> doInRedis(RedisConnection connection) throws DataAccessException {
                        HashSet<String> rawKeys = new HashSet<String>();
                        connection.keys(finalKey).stream().forEach(f -> {
                            try {
                                rawKeys.add(new String((byte[])f, "utf-8"));
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                // empty catch block
                            }
                        });
                        return rawKeys;
                    }
                });
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\uff1adeleteCacheData()\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage() + "\u3002");
            throw new AppDaoException("\u5220\u9664\u7f13\u5b58\u5185\u5bb9\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
        return rv;
    }

    @Override
    public boolean deleteRegexCacheData(String pattern) throws AppDaoException {
        boolean rv = false;
        try {
            if (!StringUtils.isEmpty((Object)pattern)) {
                final byte[] finalKey = pattern.toString().getBytes("utf-8");
                this.redisTemplate.execute((RedisCallback)new RedisCallback<Long>(){

                    public Long doInRedis(RedisConnection connection) throws DataAccessException {
                        connection.keys(finalKey).stream().forEach(f -> connection.del((byte[][])new byte[][]{f}));
                        return 0L;
                    }
                });
                rv = true;
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\uff1adeleteCacheData()\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage() + "\u3002");
            throw new AppDaoException("\u5220\u9664\u7f13\u5b58\u5185\u5bb9\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
        return rv;
    }
}

