/*
 * Decompiled with CFR 0.152.
 */
package cn.dyaoming.cache.dao;

import cn.dyaoming.cache.dao.RedisBaseImp;
import cn.dyaoming.cache.interfaces.CacheBatchInterface;
import cn.dyaoming.errors.AppDaoException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.StringUtils;

public class RedisBatchImp
extends RedisBaseImp
implements CacheBatchInterface {
    private static final Logger LOGGER = LogManager.getLogger(RedisBatchImp.class);
    @Autowired
    private RedisTemplate redisTemplate;

    @Override
    public RedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    @Override
    public void setRedisTemplate(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Override
    public boolean deleteCacheData(List<String> key) throws AppDaoException {
        boolean rv = false;
        try {
            this.redisTemplate.delete(key);
            rv = true;
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\uff1adeleteCacheData()\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage() + "\u3002");
            throw new AppDaoException("\u5220\u9664\u7f13\u5b58\u5185\u5bb9\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
        return rv;
    }

    @Override
    public boolean setList(String redisKey, List args) throws AppDaoException {
        boolean rv = false;
        try {
            this.redisTemplate.opsForList().rightPushAll((Object)redisKey, (Collection)args);
            rv = true;
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\uff1asetList()\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage() + "\u3002");
            throw new AppDaoException("redis\u8bbe\u7f6eList\u5185\u5bb9\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
        return rv;
    }

    @Override
    public boolean setList(String redisKey, Object ... args) throws AppDaoException {
        boolean rv = false;
        try {
            this.redisTemplate.opsForList().rightPushAll((Object)redisKey, args);
            rv = true;
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\uff1asetList()\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage() + "\u3002");
            throw new AppDaoException("redis\u8bbe\u7f6eList\u5185\u5bb9\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
        return rv;
    }

    @Override
    public boolean setList(String redisKey, Integer index, Object args) throws AppDaoException {
        boolean rv = false;
        try {
            this.redisTemplate.opsForList().set((Object)redisKey, (long)index.intValue(), args);
            rv = true;
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\uff1asetList()\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage() + "\u3002");
            throw new AppDaoException("redis\u8bbe\u7f6eList\u5185\u5bb9\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
        return rv;
    }

    @Override
    public boolean insertBefourIndex(String redisKey, Object index, Object value) throws AppDaoException {
        boolean rv = false;
        try {
            this.redisTemplate.opsForList().leftPush((Object)redisKey, index, value);
            rv = true;
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\uff1asetList()\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage() + "\u3002");
            throw new AppDaoException("redis\u8bbe\u7f6eList\u5185\u5bb9\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
        return rv;
    }

    @Override
    public boolean insertAfterIndex(String redisKey, Object index, Object value) throws AppDaoException {
        boolean rv = false;
        try {
            this.redisTemplate.opsForList().rightPush((Object)redisKey, index, value);
            rv = true;
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\uff1asetList()\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage() + "\u3002");
            throw new AppDaoException("redis\u8bbe\u7f6eList\u5185\u5bb9\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
        return rv;
    }

    @Override
    public Object getStack(String redisKey) throws AppDaoException {
        Object rv = null;
        try {
            rv = this.redisTemplate.opsForList().leftPop((Object)redisKey);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\uff1agetStack()\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage() + "\u3002");
            throw new AppDaoException("list\u83b7\u53d6\u6808\u4fe1\u606f\u5185\u5bb9\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
        return rv;
    }

    @Override
    public Object getHeap(String redisKey) throws AppDaoException {
        Object rv = null;
        try {
            rv = this.redisTemplate.opsForList().rightPop((Object)redisKey);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\uff1agetHeap()\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage() + "\u3002");
            throw new AppDaoException("list\u83b7\u53d6\u5806\u4fe1\u606f\u5185\u5bb9\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
        return rv;
    }

    @Override
    public Long getSize(String redisKey) throws AppDaoException {
        Long rv = null;
        try {
            rv = this.redisTemplate.opsForList().size((Object)redisKey);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\uff1agetSize()\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage() + "\u3002");
            throw new AppDaoException("list\u83b7\u53d6\u5185\u5bb9\u6570\u91cf\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
        return rv;
    }

    @Override
    public List getList(String redisKey) throws AppDaoException {
        List rv = null;
        try {
            rv = this.redisTemplate.opsForList().range((Object)redisKey, 0L, this.redisTemplate.opsForList().size((Object)redisKey).longValue());
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\uff1agetSize()\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage() + "\u3002");
            throw new AppDaoException("list\u83b7\u53d6\u5185\u5bb9\u6570\u91cf\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
        return rv;
    }

    @Override
    public Object getListValue(String redisKey, Integer index) throws AppDaoException {
        Object rv = null;
        try {
            rv = this.redisTemplate.opsForList().index((Object)redisKey, (long)index.intValue());
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\uff1agetListValue()\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage() + "\u3002");
            throw new AppDaoException("list\u83b7\u53d6\u6307\u5b9a\u4e0b\u6807\u5185\u5bb9\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
        return rv;
    }

    @Override
    public List getList(String redisKey, Integer start, Integer end) throws AppDaoException {
        List rv = null;
        try {
            rv = this.redisTemplate.opsForList().range((Object)redisKey, (long)start.intValue(), (long)end.intValue());
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\uff1agetList()\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage() + "\u3002");
            throw new AppDaoException("list\u83b7\u53d6\u6307\u5b9a\u8303\u56f4\u5185\u5bb9\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
        return rv;
    }

    @Override
    public boolean remove(String redisKey, Object value) throws AppDaoException {
        boolean rv = false;
        try {
            this.redisTemplate.opsForList().remove((Object)redisKey, 0L, value);
            rv = true;
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\uff1aremove()\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage() + "\u3002");
            throw new AppDaoException("list\u5220\u9664\u6307\u5b9a\u5185\u5bb9\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
        return rv;
    }

    @Override
    public boolean setMap(String redisKey, Map<String, String> args) throws AppDaoException {
        boolean rv = false;
        try {
            if (StringUtils.isEmpty((Object)redisKey)) {
                return false;
            }
            String finalKey = redisKey instanceof String ? redisKey : redisKey.toString();
            HashOperations hash = this.redisTemplate.opsForHash();
            hash.putAll((Object)finalKey, args);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\uff1asetMap()\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage() + "\u3002");
            throw new AppDaoException("redis\u8bbe\u7f6eMap\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
        return rv;
    }

    @Override
    public Map<String, String> getMap(String redisKey) throws AppDaoException {
        Map result = null;
        try {
            if (StringUtils.isEmpty((Object)redisKey)) {
                return null;
            }
            HashOperations hash = this.redisTemplate.opsForHash();
            result = hash.entries((Object)redisKey);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\uff1agetMap()\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage() + "\u3002");
            throw new AppDaoException("\u4eceredis\u7f13\u5b58\u4e2d\u67e5\u8be2Map\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
        return result;
    }

    @Override
    public String getFromMap(String redisKey, String mapKey) throws AppDaoException {
        String result = null;
        try {
            if (StringUtils.isEmpty((Object)redisKey)) {
                return null;
            }
            HashOperations hash = this.redisTemplate.opsForHash();
            result = (String)hash.get((Object)redisKey, (Object)mapKey);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\uff1agetFromMap()\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage() + "\u3002");
            throw new AppDaoException("\u83b7\u53d6redis\u4e2dmapKey\u5bf9\u5e94value\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
        return result;
    }

    @Override
    public void putToMap(String redisKey, String key, String value) throws AppDaoException {
        try {
            if (!StringUtils.isEmpty((Object)redisKey)) {
                HashOperations hash = this.redisTemplate.opsForHash();
                hash.put((Object)redisKey, (Object)key, (Object)value);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\uff1aputToMap()\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage() + "\u3002");
            throw new AppDaoException("\u5411map\u4e2d\u5b58\u653ekey-value\u5185\u5bb9\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
    }
}

