/*
 * Decompiled with CFR 0.152.
 */
package cn.dyaoming.cache.dao;

import cn.dyaoming.cache.interfaces.CacheBaseInterface;
import cn.dyaoming.errors.AppDaoException;
import cn.dyaoming.utils.AesUtil;
import cn.dyaoming.utils.SerializeUtil;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.StringUtils;

public class RedisBaseImp
implements CacheBaseInterface {
    private static final Logger LOGGER = LogManager.getLogger(RedisBaseImp.class);
    @Autowired
    private RedisTemplate redisTemplate;

    public RedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public void setRedisTemplate(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Override
    public boolean exists(Object key) throws AppDaoException {
        boolean rv = false;
        try {
            if (!StringUtils.isEmpty((Object)key)) {
                final byte[] finalKey = key.toString().getBytes("utf-8");
                Object obj = this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

                    public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                        return connection.exists(finalKey);
                    }
                });
                rv = (Boolean)obj;
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\uff1aexists()\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage() + "\u3002");
            throw new AppDaoException("\u5224\u65ad\u7f13\u5b58\u5185\u5bb9\u662f\u5426\u5b58\u5728\u5f02\u5e38\uff01", (Throwable)e);
        }
        return rv;
    }

    @Override
    public boolean setCacheObjectData(Object key, Object value) throws AppDaoException {
        return this.setCacheObjectData(key, value, 0L, false);
    }

    @Override
    public boolean setCacheObjectData(Object key, Object value, long validTime) throws AppDaoException {
        return this.setCacheObjectData(key, value, validTime, false);
    }

    @Override
    public boolean setCacheObjectData(Object key, Object value, boolean secret) throws AppDaoException {
        return this.setCacheObjectData(key, value, 0L, secret);
    }

    @Override
    public boolean setCacheObjectData(Object key, Object value, final long validTime, boolean secret) throws AppDaoException {
        boolean rv = false;
        try {
            if (!StringUtils.isEmpty((Object)key)) {
                final byte[] finalKey = key.toString().getBytes("utf-8");
                byte[] valueByte = SerializeUtil.serialize((Object)value);
                if (secret) {
                    valueByte = AesUtil.encrypt((byte[])valueByte);
                    int length_byte = DEFALUTHEAD.length + valueByte.length;
                    byte[] all_byte = new byte[length_byte];
                    System.arraycopy(DEFALUTHEAD, 0, all_byte, 0, DEFALUTHEAD.length);
                    System.arraycopy(valueByte, 0, all_byte, DEFALUTHEAD.length, valueByte.length);
                    valueByte = all_byte;
                }
                final byte[] finalValue = valueByte;
                Object obj = this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

                    public Boolean doInRedis(RedisConnection connection) {
                        connection.set(finalKey, finalValue);
                        if (validTime > 0L) {
                            connection.expire(finalKey, validTime);
                        }
                        return true;
                    }
                });
                rv = (Boolean)obj;
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\uff1asetCacheObjectData()\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage() + "\u3002");
            throw new AppDaoException("\u8bbe\u7f6e\u7f13\u5b58\u5185\u5bb9\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
        return rv;
    }

    @Override
    public boolean deleteCacheData(Object key) throws AppDaoException {
        boolean rv = false;
        try {
            if (!StringUtils.isEmpty((Object)key)) {
                final byte[] finalKey = key.toString().getBytes("utf-8");
                this.redisTemplate.execute((RedisCallback)new RedisCallback<Long>(){

                    public Long doInRedis(RedisConnection connection) throws DataAccessException {
                        return connection.del((byte[][])new byte[][]{finalKey});
                    }
                });
                rv = true;
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\uff1adeleteCacheData()\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage() + "\u3002");
            throw new AppDaoException("\u5220\u9664\u7f13\u5b58\u5185\u5bb9\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
        return rv;
    }

    @Override
    public Object getCacheData(Object key) throws AppDaoException {
        Object rv = null;
        try {
            if (!StringUtils.isEmpty((Object)key)) {
                Object object;
                final byte[] finalKey = key.toString().getBytes("utf-8");
                rv = object = this.redisTemplate.execute((RedisCallback)new RedisCallback<Object>(){

                    public Object doInRedis(RedisConnection connection) throws DataAccessException {
                        byte[] value = connection.get(finalKey);
                        if (value == null) {
                            return null;
                        }
                        byte[] head = new byte[CacheBaseInterface.DEFALUTHEAD.length];
                        System.arraycopy(value, 0, head, 0, CacheBaseInterface.DEFALUTHEAD.length);
                        if (Arrays.equals(head, CacheBaseInterface.DEFALUTHEAD)) {
                            byte[] body = new byte[value.length - CacheBaseInterface.DEFALUTHEAD.length];
                            System.arraycopy(value, CacheBaseInterface.DEFALUTHEAD.length, body, 0, value.length - CacheBaseInterface.DEFALUTHEAD.length);
                            body = AesUtil.decrypt((byte[])body);
                            return SerializeUtil.unSerialize((byte[])body);
                        }
                        return SerializeUtil.unSerialize((byte[])value);
                    }
                });
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\uff1agetCacheData()\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage() + "\u3002");
            throw new AppDaoException("\u83b7\u53d6\u7f13\u5b58\u5185\u5bb9\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
        return rv;
    }

    @Override
    public <T> T getCacheTData(String key, Class<T> type) throws AppDaoException {
        if (StringUtils.isEmpty((Object)key) || null == type) {
            return null;
        }
        Class<T> finalType = type;
        final String finalKey = key instanceof String ? key : key.toString();
        Object object = this.redisTemplate.execute((RedisCallback)new RedisCallback<Object>(){

            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                byte[] key = finalKey.getBytes();
                byte[] value = connection.get(key);
                if (value == null) {
                    return null;
                }
                return SerializeUtil.unSerialize((byte[])value);
            }
        });
        if (finalType != null && finalType.isInstance(object) && null != object) {
            return (T)object;
        }
        return null;
    }

    @Override
    public void clear() throws AppDaoException {
        this.redisTemplate.discard();
    }
}

