/*
 * Decompiled with CFR 0.152.
 */
package cn.dyaoming.cache;

import cn.dyaoming.cache.interfaces.CacheInterface;
import cn.dyaoming.utils.SpringUtil;
import java.util.concurrent.Callable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.util.StringUtils;

public class SystemCache
implements Cache {
    @Autowired
    private CacheInterface cacheDao;
    private String name;
    private long timeout;
    private boolean secret;

    public SystemCache() {
    }

    public SystemCache(String name, long timeout, boolean secret) {
        this.setName(name);
        this.setTimeout(timeout);
        this.secret = secret;
        this.setCacheDao((CacheInterface)SpringUtil.getBean((String)"cacheDao"));
    }

    public Object getNativeCache() {
        return this.cacheDao;
    }

    public Cache.ValueWrapper get(Object key) {
        if (StringUtils.isEmpty((Object)key)) {
            return null;
        }
        String finalKey = key instanceof String ? (String)key : key.toString();
        Object object = this.cacheDao.getCacheData("cache:" + this.getName() + ":" + finalKey);
        return object != null ? new SimpleValueWrapper(object) : null;
    }

    public <T> T get(Object key, Class<T> type) {
        if (StringUtils.isEmpty((Object)key) || type == null) {
            return null;
        }
        Object object = this.cacheDao.getCacheData("cache:" + this.getName() + ":" + key);
        if (type != null && type.isInstance(object) && object != null) {
            return (T)object;
        }
        return null;
    }

    public <T> T get(Object key, Callable<T> valueLoader) {
        return null;
    }

    public void put(Object key, Object value) {
        if (StringUtils.isEmpty((Object)key) || StringUtils.isEmpty((Object)value) || this.timeout == 0L) {
            return;
        }
        this.cacheDao.setCacheObjectData("cache:" + this.getName() + ":" + key, value, this.timeout, this.secret);
    }

    public void evict(Object key) {
        if (!StringUtils.isEmpty((Object)key)) {
            this.cacheDao.deleteCacheData("cache:" + this.getName() + ":" + key);
        }
    }

    public void clear() {
        this.cacheDao.clear();
    }

    public Cache.ValueWrapper putIfAbsent(Object arg0, Object arg1) {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setSecret(String secret) {
        this.secret = "true".equalsIgnoreCase(secret);
    }

    public void setCacheDao(CacheInterface cacheDao) {
        this.cacheDao = cacheDao;
    }
}

