/*
 * Decompiled with CFR 0.152.
 */
package cn.dyaoming.cache;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.util.ClassUtils;

public class CacheKeyGenerator
implements KeyGenerator {
    public static final int NO_PARAM_KEY = 0;
    public static final int NULL_PARAM_KEY = 53;

    public Object generate(Object target, Method method, Object ... params) {
        StringBuilder key = new StringBuilder();
        key.append(target.getClass().getName()).append(".").append(method.getName()).append("[");
        if (params.length == 0) {
            return key.append(0).toString();
        }
        Object[] objectArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            Object param = objectArray[n2];
            if (param == null) {
                key.append(53);
            } else if (ClassUtils.isPrimitiveArray(param.getClass())) {
                int length = Array.getLength(param);
                int i = 0;
                while (i < length) {
                    key.append(Array.get(param, i));
                    key.append(',');
                    ++i;
                }
            } else if (ClassUtils.isPrimitiveOrWrapper(param.getClass()) || param instanceof String) {
                key.append(param);
            } else {
                key.append(param.hashCode());
            }
            key.append('-');
            ++n2;
        }
        if (key.lastIndexOf("-") == key.length() - 1) {
            key.deleteCharAt(key.length() - 1);
        }
        key.append(']');
        return key.toString();
    }
}

