/*
 * Decompiled with CFR 0.152.
 */
package cn.dyaoming.cache.redistemplate;

import cn.dyaoming.cache.interfaces.CacheRegexInterface;
import cn.dyaoming.cache.redistemplate.RedisBaseImp;
import cn.dyaoming.errors.AppDaoException;
import cn.dyaoming.utils.StringUtil;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.util.StringUtils;

public abstract class RedisRegexImp
extends RedisBaseImp
implements CacheRegexInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisRegexImp.class);

    public Collection<String> getKeys(String pattern) throws AppDaoException {
        HashSet<String> rv = new HashSet<String>();
        try {
            if (!StringUtils.isEmpty((Object)pattern)) {
                final byte[] finalKey = pattern.toString().getBytes("utf-8");
                Set keys = (Set)this.redisTemplate.execute((RedisCallback)new RedisCallback<Set<byte[]>>(){

                    public Set<byte[]> doInRedis(RedisConnection connection) throws DataAccessException {
                        RedisRegexImp.this.selectDb(connection);
                        return connection.keys(finalKey);
                    }
                });
                keys.stream().forEach(f -> {
                    try {
                        rv.add(new String((byte[])f, "utf-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                });
            }
        }
        catch (Exception e) {
            LOGGER.warn("\u5f02\u5e38\uff1agetKeys()\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage() + "\u3002");
            throw new AppDaoException("\u6a21\u7cca\u67e5\u8be2keys\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
        return rv;
    }

    public boolean deleteRegexCacheData(String pattern) throws AppDaoException {
        boolean rv = false;
        try {
            if (StringUtil.isNotEmpty((CharSequence)pattern)) {
                final byte[] finalKey = pattern.toString().getBytes("utf-8");
                this.redisTemplate.execute((RedisCallback)new RedisCallback<Long>(){

                    public Long doInRedis(RedisConnection connection) throws DataAccessException {
                        RedisRegexImp.this.selectDb(connection);
                        Set keys = connection.keys(finalKey);
                        byte[][] rawKeys = new byte[keys.size()][];
                        int i = 0;
                        for (byte[] key : keys) {
                            rawKeys[i++] = key;
                        }
                        connection.del((byte[][])rawKeys);
                        return 0L;
                    }
                });
                rv = true;
            }
        }
        catch (Exception e) {
            LOGGER.warn("\u5f02\u5e38\uff1adeleteCacheData()\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage() + "\u3002");
            throw new AppDaoException("\u5220\u9664\u7f13\u5b58\u5185\u5bb9\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
        return rv;
    }
}

