/*
 * Decompiled with CFR 0.152.
 */
package cn.dyaoming.cache.redistemplate;

import cn.dyaoming.cache.interfaces.CacheBaseInterface;
import cn.dyaoming.errors.AppDaoException;
import cn.dyaoming.utils.AesUtil;
import cn.dyaoming.utils.SerializeUtil;
import cn.dyaoming.utils.StringUtil;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;

public abstract class RedisBaseImp
implements CacheBaseInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisBaseImp.class);
    protected Integer dbIndex = null;
    protected RedisTemplate redisTemplate;

    @Autowired
    public void setRedisTemplate(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public void init(String dbIndex) {
        this.dbIndex = StringUtil.isNotEmpty((CharSequence)dbIndex) ? Integer.valueOf(dbIndex) : null;
    }

    protected void selectDb(RedisConnection connection) {
        if (this.dbIndex != null) {
            connection.select(this.dbIndex.intValue());
        }
    }

    public boolean exists(Object key) throws AppDaoException {
        boolean rv = false;
        try {
            if (StringUtil.isNotEmpty((Object)key)) {
                final byte[] finalKey = key.toString().getBytes("utf-8");
                Object obj = this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

                    public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                        RedisBaseImp.this.selectDb(connection);
                        return connection.exists(finalKey);
                    }
                });
                rv = (Boolean)obj;
            }
        }
        catch (Exception e) {
            LOGGER.warn("\u5f02\u5e38\uff1aexists()\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage() + "\u3002");
        }
        return rv;
    }

    public boolean setCacheObjectData(Object key, Object value) throws AppDaoException {
        return this.setCacheObjectData(key, value, -1L, false);
    }

    public boolean setCacheObjectData(Object key, Object value, long validTime) throws AppDaoException {
        return this.setCacheObjectData(key, value, validTime, false);
    }

    public boolean setCacheObjectData(Object key, Object value, boolean secret) throws AppDaoException {
        return this.setCacheObjectData(key, value, -1L, secret);
    }

    public boolean setCacheObjectData(Object key, Object value, final long validTime, boolean secret) throws AppDaoException {
        boolean rv = false;
        try {
            if (StringUtil.isNotEmpty((Object)key)) {
                final byte[] finalKey = key.toString().getBytes("utf-8");
                byte[] valueByte = SerializeUtil.serialize((Object)value);
                if (secret) {
                    valueByte = AesUtil.encrypt((byte[])valueByte);
                    int length_byte = DEFALUTHEAD.length + valueByte.length;
                    byte[] all_byte = new byte[length_byte];
                    System.arraycopy(DEFALUTHEAD, 0, all_byte, 0, DEFALUTHEAD.length);
                    System.arraycopy(valueByte, 0, all_byte, DEFALUTHEAD.length, valueByte.length);
                    valueByte = all_byte;
                }
                final byte[] finalValue = valueByte;
                Object obj = this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

                    public Boolean doInRedis(RedisConnection connection) {
                        RedisBaseImp.this.selectDb(connection);
                        connection.set(finalKey, finalValue);
                        if (validTime > 0L) {
                            connection.expire(finalKey, validTime);
                        }
                        return true;
                    }
                });
                rv = (Boolean)obj;
            }
        }
        catch (Exception e) {
            LOGGER.warn("\u5f02\u5e38\uff1asetCacheObjectData()\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage() + "\u3002");
        }
        return rv;
    }

    public boolean deleteCacheData(Object key) throws AppDaoException {
        boolean rv = false;
        try {
            if (StringUtil.isNotEmpty((Object)key)) {
                final byte[] finalKey = key.toString().getBytes("utf-8");
                this.redisTemplate.execute((RedisCallback)new RedisCallback<Long>(){

                    public Long doInRedis(RedisConnection connection) throws DataAccessException {
                        RedisBaseImp.this.selectDb(connection);
                        return connection.del((byte[][])new byte[][]{finalKey});
                    }
                });
                rv = true;
            }
        }
        catch (Exception e) {
            LOGGER.warn("\u5f02\u5e38\uff1adeleteCacheData()\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage() + "\u3002");
        }
        return rv;
    }

    public Object getCacheData(Object key) throws AppDaoException {
        Object rv = null;
        try {
            byte[] finalKey;
            byte[] value;
            if (StringUtil.isNotEmpty((Object)key) && StringUtil.isNotEmpty((Object)(value = (byte[])this.redisTemplate.execute((RedisCallback)new RedisCallback<byte[]>(finalKey = key.toString().getBytes("utf-8")){
                final /* synthetic */ byte[] val$finalKey;
                {
                    this.val$finalKey = byArray;
                }

                public byte[] doInRedis(RedisConnection connection) throws DataAccessException {
                    RedisBaseImp.this.selectDb(connection);
                    return connection.get(this.val$finalKey);
                }
            })))) {
                byte[] head = new byte[DEFALUTHEAD.length];
                System.arraycopy(value, 0, head, 0, DEFALUTHEAD.length);
                if (Arrays.equals(head, DEFALUTHEAD)) {
                    byte[] body = new byte[value.length - DEFALUTHEAD.length];
                    System.arraycopy(value, DEFALUTHEAD.length, body, 0, value.length - DEFALUTHEAD.length);
                    body = AesUtil.decrypt((byte[])body);
                    rv = SerializeUtil.unSerialize((byte[])body);
                }
                rv = SerializeUtil.unSerialize((byte[])value);
            }
        }
        catch (Exception e) {
            LOGGER.warn("\u5f02\u5e38\uff1agetCacheData()\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage() + "\u3002");
        }
        return rv;
    }

    public <T> T getCacheTData(String key, Class<T> type) throws AppDaoException {
        Object rv = null;
        try {
            byte[] finalKey;
            byte[] value;
            if (StringUtil.isNotEmpty((CharSequence)key) && type != null && StringUtil.isNotEmpty((Object)(value = (byte[])this.redisTemplate.execute((RedisCallback)new RedisCallback<byte[]>(finalKey = key.toString().getBytes("utf-8")){
                final /* synthetic */ byte[] val$finalKey;
                {
                    this.val$finalKey = byArray;
                }

                public byte[] doInRedis(RedisConnection connection) throws DataAccessException {
                    RedisBaseImp.this.selectDb(connection);
                    return connection.get(this.val$finalKey);
                }
            })))) {
                byte[] head = new byte[DEFALUTHEAD.length];
                System.arraycopy(value, 0, head, 0, DEFALUTHEAD.length);
                Object rb = null;
                if (Arrays.equals(head, DEFALUTHEAD)) {
                    byte[] body = new byte[value.length - DEFALUTHEAD.length];
                    System.arraycopy(value, DEFALUTHEAD.length, body, 0, value.length - DEFALUTHEAD.length);
                    body = AesUtil.decrypt((byte[])body);
                    rb = SerializeUtil.unSerialize((byte[])body);
                } else {
                    rb = SerializeUtil.unSerialize((byte[])value);
                }
                if (type.isInstance(rb) && null != rb) {
                    rv = rb;
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("\u83b7\u53d6\u7f13\u5b58\u5185\u5bb9\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
        return (T)rv;
    }

    public void clear() throws AppDaoException {
        try {
            this.redisTemplate.execute((RedisCallback)new RedisCallback<Object>(){

                public Object doInRedis(RedisConnection connection) throws DataAccessException {
                    RedisBaseImp.this.selectDb(connection);
                    connection.flushDb();
                    return 0L;
                }
            });
        }
        catch (Exception e) {
            LOGGER.warn("\u6e05\u7a7a\u7f13\u5b58\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
    }

    public boolean tryLock(String key, String serial, long expire) {
        return (Boolean)this.redisTemplate.execute(connection -> {
            Boolean acquire = connection.setNX(key.getBytes(), serial.getBytes());
            if (acquire.booleanValue()) {
                connection.expire(key.getBytes(), expire);
                return true;
            }
            byte[] value = connection.get(key.getBytes());
            if (Objects.nonNull(value) && value.length > 0) {
                return Arrays.equals(value, serial.getBytes());
            }
            return false;
        });
    }

    public boolean getLock(String key, String serial, long expire, long waittime) {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() <= startTime + waittime * 1000L) {
            if (this.tryLock(key, serial, expire)) {
                return true;
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean releaseLock(String key, String serial) {
        return (Boolean)this.redisTemplate.execute(connection -> {
            byte[] value = connection.get(key.getBytes());
            if (Objects.nonNull(value) && value.length > 0 && Arrays.equals(value, serial.getBytes())) {
                connection.del((byte[][])new byte[][]{key.getBytes()});
                return true;
            }
            return false;
        });
    }
}

