/*
 * Decompiled with CFR 0.152.
 */
package cn.dyaoming.cache.jedissentinel;

import cn.dyaoming.cache.interfaces.CacheRegexInterface;
import cn.dyaoming.cache.jedissentinel.RedisBaseImp;
import cn.dyaoming.errors.AppDaoException;
import cn.dyaoming.utils.StringUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;

public abstract class RedisRegexImp
extends RedisBaseImp
implements CacheRegexInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisRegexImp.class);

    public Collection<String> getKeys(String pattern) throws AppDaoException {
        Set<String> rv = new HashSet<String>();
        Jedis jedis = null;
        try {
            if (StringUtil.isNotEmpty((CharSequence)pattern)) {
                jedis = this.getResource();
                this.selectDb(jedis);
                rv = jedis.keys(pattern);
            }
        }
        catch (Exception e) {
            try {
                LOGGER.warn("\u5f02\u5e38\uff1agetKeys()\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage() + "\u3002");
                throw new AppDaoException("\u6a21\u7cca\u67e5\u8be2keys\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
            }
            catch (Throwable throwable) {
                this.closeResource(jedis);
                throw throwable;
            }
        }
        this.closeResource(jedis);
        return rv;
    }

    public boolean deleteRegexCacheData(String pattern) throws AppDaoException {
        boolean rv = false;
        Jedis jedis = null;
        try {
            if (StringUtil.isNotEmpty((CharSequence)pattern)) {
                jedis = this.getResource();
                this.selectDb(jedis);
                Collection<String> keys = this.getKeys(pattern);
                String[] stringKeys = new String[keys.size()];
                int i = 0;
                for (String key : keys) {
                    stringKeys[i++] = key;
                }
                jedis.del(stringKeys);
                rv = true;
            }
        }
        catch (Exception e) {
            try {
                LOGGER.warn("\u5f02\u5e38\uff1adeleteRegexCacheData()\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage() + "\u3002");
                throw new AppDaoException("\u5220\u9664\u7f13\u5b58\u5185\u5bb9\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
            }
            catch (Throwable throwable) {
                this.closeResource(jedis);
                throw throwable;
            }
        }
        this.closeResource(jedis);
        return rv;
    }
}

