/*
 * Decompiled with CFR 0.152.
 */
package cn.dyaoming.cache.jedispool;

import cn.dyaoming.cache.interfaces.CacheBaseInterface;
import cn.dyaoming.errors.AppDaoException;
import cn.dyaoming.utils.AesUtil;
import cn.dyaoming.utils.SerializeUtil;
import cn.dyaoming.utils.StringUtil;
import java.util.Arrays;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public abstract class RedisBaseImp
implements CacheBaseInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisBaseImp.class);
    protected Integer dbIndex = null;
    private JedisPool jedisPool;

    @Autowired
    public void setJedisPool(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    public void init(String dbIndex) {
        this.dbIndex = StringUtil.isNotEmpty((CharSequence)dbIndex) ? Integer.valueOf(dbIndex) : null;
    }

    protected Jedis getResource() {
        return this.jedisPool.getResource();
    }

    protected void selectDb(Jedis jedis) {
        if (this.dbIndex != null) {
            jedis.select(this.dbIndex.intValue());
        }
    }

    protected void closeResource(Jedis jedis) {
        try {
            if (jedis != null) {
                jedis.close();
            }
        }
        catch (Exception e) {
            LOGGER.warn("\u5173\u95edjedis\u8fde\u63a5\u6c60\u5f02\u5e38", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(Object key) throws AppDaoException {
        Jedis jedis = null;
        boolean rv = false;
        try {
            if (StringUtil.isNotEmpty((Object)key)) {
                jedis = this.getResource();
                this.selectDb(jedis);
                rv = jedis.exists(key.toString());
            }
            this.closeResource(jedis);
        }
        catch (Throwable throwable) {
            this.closeResource(jedis);
            throw throwable;
        }
        return rv;
    }

    public boolean setCacheObjectData(Object key, Object value) throws AppDaoException {
        return this.setCacheObjectData(key, value, -1L, false);
    }

    public boolean setCacheObjectData(Object key, Object value, long validTime) throws AppDaoException {
        return this.setCacheObjectData(key, value, validTime, false);
    }

    public boolean setCacheObjectData(Object key, Object value, boolean secret) throws AppDaoException {
        return this.setCacheObjectData(key, value, -1L, secret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setCacheObjectData(Object key, Object value, long validTime, boolean secret) throws AppDaoException {
        boolean rv = false;
        Jedis jedis = null;
        try {
            if (StringUtil.isNotEmpty((Object)key)) {
                byte[] finalKey = key.toString().getBytes("utf-8");
                byte[] valueByte = SerializeUtil.serialize((Object)value);
                if (secret) {
                    valueByte = AesUtil.encrypt((byte[])valueByte);
                    int lengthByte = DEFALUTHEAD.length + valueByte.length;
                    byte[] allByte = new byte[lengthByte];
                    System.arraycopy(DEFALUTHEAD, 0, allByte, 0, DEFALUTHEAD.length);
                    System.arraycopy(valueByte, 0, allByte, DEFALUTHEAD.length, valueByte.length);
                    valueByte = allByte;
                }
                byte[] finalValue = valueByte;
                jedis = this.getResource();
                this.selectDb(jedis);
                if (validTime > 0L) {
                    int expireTime = new Long(validTime).intValue();
                    jedis.setex(finalKey, expireTime, finalValue);
                } else {
                    jedis.set(finalKey, finalValue);
                }
                rv = true;
            }
        }
        catch (Exception e) {
            LOGGER.warn("\u4fdd\u5b58\u7f13\u5b58\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38 ", (Throwable)e);
            rv = false;
        }
        finally {
            this.closeResource(jedis);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteCacheData(Object key) throws AppDaoException {
        boolean rv = false;
        Jedis jedis = null;
        try {
            if (StringUtil.isNotEmpty((Object)key)) {
                byte[] finalKey = key.toString().getBytes("utf-8");
                jedis = this.getResource();
                this.selectDb(jedis);
                jedis.del(finalKey);
                rv = true;
            }
        }
        catch (Exception e) {
            LOGGER.warn("\u5220\u9664\u7f13\u5b58\u5185\u5bb9\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        finally {
            this.closeResource(jedis);
        }
        return rv;
    }

    public Object getCacheData(Object key) throws AppDaoException {
        Object rv = null;
        Jedis jedis = null;
        try {
            if (StringUtil.isNotEmpty((Object)key)) {
                byte[] finalKey = key.toString().getBytes("utf-8");
                jedis = this.getResource();
                this.selectDb(jedis);
                byte[] value = jedis.get(finalKey);
                if (StringUtil.isNotEmpty((Object)value)) {
                    byte[] head = new byte[DEFALUTHEAD.length];
                    System.arraycopy(value, 0, head, 0, DEFALUTHEAD.length);
                    if (Arrays.equals(head, DEFALUTHEAD)) {
                        byte[] body = new byte[value.length - DEFALUTHEAD.length];
                        System.arraycopy(value, DEFALUTHEAD.length, body, 0, value.length - DEFALUTHEAD.length);
                        body = AesUtil.decrypt((byte[])body);
                        rv = SerializeUtil.unSerialize((byte[])body);
                    }
                    rv = SerializeUtil.unSerialize((byte[])value);
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("\u83b7\u53d6\u7f13\u5b58\u5185\u5bb9\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
            throw new AppDaoException("\u83b7\u53d6\u7f13\u5b58\u5185\u5bb9\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
        finally {
            this.closeResource(jedis);
        }
        return rv;
    }

    public <T> T getCacheTData(String key, Class<T> type) throws AppDaoException {
        Object rv = null;
        Jedis jedis = null;
        try {
            if (StringUtil.isNotEmpty((CharSequence)key) && type != null) {
                byte[] finalKey = key.getBytes("utf-8");
                jedis = this.getResource();
                this.selectDb(jedis);
                byte[] value = jedis.get(finalKey);
                if (StringUtil.isNotEmpty((Object)value)) {
                    byte[] head = new byte[DEFALUTHEAD.length];
                    System.arraycopy(value, 0, head, 0, DEFALUTHEAD.length);
                    Object rb = null;
                    if (Arrays.equals(head, DEFALUTHEAD)) {
                        byte[] body = new byte[value.length - DEFALUTHEAD.length];
                        System.arraycopy(value, DEFALUTHEAD.length, body, 0, value.length - DEFALUTHEAD.length);
                        body = AesUtil.decrypt((byte[])body);
                        rb = SerializeUtil.unSerialize((byte[])body);
                    } else {
                        rb = SerializeUtil.unSerialize((byte[])value);
                    }
                    if (type.isInstance(rb) && null != rb) {
                        rv = rb;
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("\u83b7\u53d6\u7f13\u5b58\u5185\u5bb9\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
            throw new AppDaoException("\u83b7\u53d6\u7f13\u5b58\u5185\u5bb9\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
        finally {
            this.closeResource(jedis);
        }
        return (T)rv;
    }

    public void clear() throws AppDaoException {
        Jedis jedis = null;
        try {
            jedis = this.getResource();
            this.selectDb(jedis);
            jedis.flushDB();
        }
        finally {
            this.closeResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryLock(String key, String serial, long expire) {
        Jedis jedis = null;
        try {
            jedis = this.getResource();
            this.selectDb(jedis);
            String rv = jedis.set(key, serial, "NX", "EX", expire);
            if ("OK".equals(rv)) {
                boolean bl = true;
                return bl;
            }
            String value = jedis.get(key);
            if (!StringUtils.isEmpty((Object)value)) {
                boolean bl = value.equals(serial);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeResource(jedis);
        }
    }

    public boolean getLock(String key, String serial, long expire, long waittime) {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() <= startTime + waittime * 1000L) {
            if (this.tryLock(key, serial, expire)) {
                return true;
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean releaseLock(String key, String serial) {
        Jedis jedis = null;
        try {
            jedis = this.getResource();
            this.selectDb(jedis);
            String script = "if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end";
            Object rv = jedis.eval(script, Collections.singletonList(key), Collections.singletonList(serial));
            boolean bl = "OK".equals(rv);
            return bl;
        }
        finally {
            this.closeResource(jedis);
        }
    }
}

