/*
 * Decompiled with CFR 0.152.
 */
package cn.dyaoming.cache.jediscluster;

import cn.dyaoming.cache.interfaces.CacheRegexInterface;
import cn.dyaoming.cache.jediscluster.RedisBaseImp;
import cn.dyaoming.errors.AppDaoException;
import cn.dyaoming.utils.StringUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RedisRegexImp
extends RedisBaseImp
implements CacheRegexInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisRegexImp.class);

    public Collection<String> getKeys(String pattern) throws AppDaoException {
        Set<String> rv = new HashSet<String>();
        try {
            if (StringUtil.isNotEmpty((CharSequence)pattern)) {
                rv = this.jedisCluster.hkeys(pattern);
            }
        }
        catch (Exception e) {
            LOGGER.warn("\u5f02\u5e38\uff1agetKeys()\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage() + "\u3002");
            throw new AppDaoException("\u6a21\u7cca\u67e5\u8be2keys\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
        return rv;
    }

    public boolean deleteRegexCacheData(String pattern) throws AppDaoException {
        boolean rv = false;
        try {
            if (StringUtil.isNotEmpty((CharSequence)pattern)) {
                Collection<String> keys = this.getKeys(pattern);
                String[] stringKeys = new String[keys.size()];
                int i = 0;
                for (String key : keys) {
                    stringKeys[i++] = key;
                }
                this.jedisCluster.del(stringKeys);
                rv = true;
            }
        }
        catch (Exception e) {
            LOGGER.warn("\u5f02\u5e38\uff1adeleteRegexCacheData()\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage() + "\u3002");
            throw new AppDaoException("\u5220\u9664\u7f13\u5b58\u5185\u5bb9\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
        return rv;
    }
}

