/*
 * Decompiled with CFR 0.152.
 */
package cn.dyaoming.cache.jediscluster;

import cn.dyaoming.cache.interfaces.CacheBaseInterface;
import cn.dyaoming.errors.AppDaoException;
import cn.dyaoming.utils.AesUtil;
import cn.dyaoming.utils.SerializeUtil;
import cn.dyaoming.utils.StringUtil;
import java.util.Arrays;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import redis.clients.jedis.JedisCluster;

public abstract class RedisBaseImp
implements CacheBaseInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisBaseImp.class);
    protected JedisCluster jedisCluster;

    @Autowired
    public void setJedisCluster(JedisCluster jedisCluster) {
        this.jedisCluster = jedisCluster;
    }

    public void init(String dbIndex) {
    }

    public boolean exists(Object key) throws AppDaoException {
        boolean rv = false;
        if (StringUtil.isNotEmpty((Object)key)) {
            rv = this.jedisCluster.exists(key.toString());
        }
        return rv;
    }

    public boolean setCacheObjectData(Object key, Object value) throws AppDaoException {
        return this.setCacheObjectData(key, value, -1L, false);
    }

    public boolean setCacheObjectData(Object key, Object value, long validTime) throws AppDaoException {
        return this.setCacheObjectData(key, value, validTime, false);
    }

    public boolean setCacheObjectData(Object key, Object value, boolean secret) throws AppDaoException {
        return this.setCacheObjectData(key, value, -1L, secret);
    }

    public boolean setCacheObjectData(Object key, Object value, long validTime, boolean secret) throws AppDaoException {
        boolean rv = false;
        try {
            if (StringUtil.isNotEmpty((Object)key)) {
                byte[] finalKey = key.toString().getBytes("utf-8");
                byte[] valueByte = SerializeUtil.serialize((Object)value);
                if (secret) {
                    valueByte = AesUtil.encrypt((byte[])valueByte);
                    int lengthByte = DEFALUTHEAD.length + valueByte.length;
                    byte[] allByte = new byte[lengthByte];
                    System.arraycopy(DEFALUTHEAD, 0, allByte, 0, DEFALUTHEAD.length);
                    System.arraycopy(valueByte, 0, allByte, DEFALUTHEAD.length, valueByte.length);
                    valueByte = allByte;
                }
                byte[] finalValue = valueByte;
                if (validTime > 0L) {
                    int expireTime = new Long(validTime).intValue();
                    this.jedisCluster.setex(finalKey, expireTime, finalValue);
                } else {
                    this.jedisCluster.set(finalKey, finalValue);
                }
                rv = true;
            }
        }
        catch (Exception e) {
            LOGGER.warn("\u4fdd\u5b58\u7f13\u5b58\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38 ", (Throwable)e);
            rv = false;
        }
        return rv;
    }

    public boolean deleteCacheData(Object key) throws AppDaoException {
        boolean rv = false;
        try {
            if (StringUtil.isNotEmpty((Object)key)) {
                byte[] finalKey = key.toString().getBytes("utf-8");
                this.jedisCluster.del(finalKey);
                rv = true;
            }
        }
        catch (Exception e) {
            LOGGER.warn("\u5220\u9664\u7f13\u5b58\u5185\u5bb9\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        return rv;
    }

    public Object getCacheData(Object key) throws AppDaoException {
        Object rv = null;
        try {
            byte[] finalKey;
            byte[] value;
            if (StringUtil.isNotEmpty((Object)key) && StringUtil.isNotEmpty((Object)(value = this.jedisCluster.get(finalKey = key.toString().getBytes("utf-8"))))) {
                byte[] head = new byte[DEFALUTHEAD.length];
                System.arraycopy(value, 0, head, 0, DEFALUTHEAD.length);
                if (Arrays.equals(head, DEFALUTHEAD)) {
                    byte[] body = new byte[value.length - DEFALUTHEAD.length];
                    System.arraycopy(value, DEFALUTHEAD.length, body, 0, value.length - DEFALUTHEAD.length);
                    body = AesUtil.decrypt((byte[])body);
                    rv = SerializeUtil.unSerialize((byte[])body);
                }
                rv = SerializeUtil.unSerialize((byte[])value);
            }
        }
        catch (Exception e) {
            LOGGER.warn("\u83b7\u53d6\u7f13\u5b58\u5185\u5bb9\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
        return rv;
    }

    public <T> T getCacheTData(String key, Class<T> type) throws AppDaoException {
        Object rv = null;
        try {
            byte[] finalKey;
            byte[] value;
            if (StringUtil.isNotEmpty((CharSequence)key) && type != null && StringUtil.isNotEmpty((Object)(value = this.jedisCluster.get(finalKey = key.getBytes("utf-8"))))) {
                byte[] head = new byte[DEFALUTHEAD.length];
                System.arraycopy(value, 0, head, 0, DEFALUTHEAD.length);
                Object rb = null;
                if (Arrays.equals(head, DEFALUTHEAD)) {
                    byte[] body = new byte[value.length - DEFALUTHEAD.length];
                    System.arraycopy(value, DEFALUTHEAD.length, body, 0, value.length - DEFALUTHEAD.length);
                    body = AesUtil.decrypt((byte[])body);
                    rb = SerializeUtil.unSerialize((byte[])body);
                } else {
                    rb = SerializeUtil.unSerialize((byte[])value);
                }
                if (type.isInstance(rb) && null != rb) {
                    rv = rb;
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("\u83b7\u53d6\u7f13\u5b58\u5185\u5bb9\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
        return (T)rv;
    }

    public void clear() throws AppDaoException {
        this.jedisCluster.flushAll();
    }

    public boolean tryLock(String key, String serial, long expire) {
        String rv = this.jedisCluster.set(key, serial, "NX", "EX", expire);
        if ("OK".equals(rv)) {
            return true;
        }
        String value = this.jedisCluster.get(key);
        if (!StringUtils.isEmpty((Object)value)) {
            return value.equals(serial);
        }
        return false;
    }

    public boolean getLock(String key, String serial, long expire, long waittime) {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() <= startTime + waittime * 1000L) {
            if (this.tryLock(key, serial, expire)) {
                return true;
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean releaseLock(String key, String serial) {
        String script = "if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end";
        Object rv = this.jedisCluster.eval(script, Collections.singletonList(key), Collections.singletonList(serial));
        return "OK".equals(rv);
    }
}

