/*
 * Decompiled with CFR 0.152.
 */
package cn.dustlight.jobless.kubernetes;

import cn.dustlight.jobless.core.Utils;
import cn.dustlight.jobless.kubernetes.Accessible;
import cn.dustlight.jobless.kubernetes.HttpTriggerSpec;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.models.V1ObjectMeta;

public class HttpTriggerObject
implements KubernetesObject,
Accessible {
    private V1ObjectMeta metadata;
    private String apiVersion;
    private String kind;
    private HttpTriggerSpec spec;

    @Override
    public String getUrl() {
        return this.spec == null ? null : String.format("%s://%s/%s", "http", this.spec.getHostName(), Utils.getSuffix((String)this.spec.getFunctionName()));
    }

    @Override
    public String getKey() {
        return this.spec.getFunctionName();
    }

    public String toString() {
        return this.getUrl();
    }

    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getKind() {
        return this.kind;
    }

    public HttpTriggerSpec getSpec() {
        return this.spec;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public void setSpec(HttpTriggerSpec spec) {
        this.spec = spec;
    }
}

