/*
 * Decompiled with CFR 0.152.
 */
package cn.dustlight.jobless.kubernetes;

import cn.dustlight.jobless.kubernetes.Accessible;
import cn.dustlight.jobless.kubernetes.FunctionSpec;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ServicePort;
import java.util.List;

public class FunctionObject
implements KubernetesObject,
Accessible {
    public static final String DEFAULT_NAMESPACE = "default";
    private V1ObjectMeta metadata;
    private String apiVersion;
    private String kind;
    private FunctionSpec spec;

    @Override
    public String getUrl() {
        List ports;
        String namespace = this.metadata.getNamespace();
        if (namespace == null || namespace.trim().length() == 0) {
            namespace = DEFAULT_NAMESPACE;
        }
        int port = 80;
        if (this.spec.getService() != null && (ports = this.spec.getService().getPorts()) != null && ports.size() > 0) {
            port = ((V1ServicePort)ports.get(0)).getPort();
        }
        return String.format("http://%s.%s:%d/", this.metadata.getName(), namespace, port);
    }

    @Override
    public String getKey() {
        return this.metadata.getName();
    }

    public String toString() {
        return this.getUrl();
    }

    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getKind() {
        return this.kind;
    }

    public FunctionSpec getSpec() {
        return this.spec;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public void setSpec(FunctionSpec spec) {
        this.spec = spec;
    }
}

