/*
 * Decompiled with CFR 0.152.
 */
package cn.dustlight.jobless.kubernetes;

import cn.dustlight.jobless.core.AbstractJobHandler;
import cn.dustlight.jobless.kubernetes.Accessible;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public class AccessibleJobHandler<T extends Accessible>
extends AbstractJobHandler<T> {
    private OkHttpClient client;
    private ObjectMapper objectMapper = new ObjectMapper();

    public AccessibleJobHandler(T spec, OkHttpClient client) {
        super(spec);
        this.client = client;
    }

    public AccessibleJobHandler(T spec) {
        this(spec, new OkHttpClient());
    }

    protected AbstractJobHandler.Response handle(ActivatedJob job, T accessible) throws Throwable {
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)job.toJson());
        return (AbstractJobHandler.Response)this.objectMapper.readValue(this.client.newCall(new Request.Builder().url(accessible.getUrl()).post(body).build()).execute().body().byteStream(), AbstractJobHandler.Response.class);
    }

    public OkHttpClient getClient() {
        return this.client;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setClient(OkHttpClient client) {
        this.client = client;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

