/*
 * Decompiled with CFR 0.152.
 */
package cn.dustlight.jobless.kubernetes;

import cn.dustlight.jobless.core.JobHandlerProvider;
import cn.dustlight.jobless.kubernetes.Accessible;
import cn.dustlight.jobless.kubernetes.AccessibleJobHandler;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.util.Config;
import io.kubernetes.client.util.Watch;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractWatcher<T extends Accessible>
extends JobHandlerProvider<T>
implements Runnable,
InitializingBean {
    private ApiClient client;
    private OkHttpClient httpClient;
    private boolean closed;
    private ExecutorService executorService = Executors.newFixedThreadPool(1);

    public AbstractWatcher(JobHandlerProvider.JobHandlerUpListener<T> upListener, JobHandlerProvider.JobHandlerDownListener downListener) {
        super(upListener, downListener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.closed = false;
        try {
            Call watchCall = this.createWatchCall();
            try (Watch watch = Watch.createWatch((ApiClient)this.client, (Call)watchCall, (Type)this.getType());){
                block19: while (watch.hasNext()) {
                    if (Thread.interrupted()) return;
                    Watch.Response item = watch.next();
                    switch (item.type) {
                        case "DELETED": {
                            this.callDown(((Accessible)item.object).getKey());
                            continue block19;
                        }
                    }
                    this.callUp(((Accessible)item.object).getKey(), new AccessibleJobHandler<Accessible>((Accessible)item.object, this.httpClient));
                }
                return;
            }
        }
        catch (InterruptedException watchCall) {
            return;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.closed = true;
        }
    }

    protected abstract Call createWatchCall() throws Exception;

    protected abstract Type getType();

    public void afterPropertiesSet() throws Exception {
        if (this.client == null) {
            this.client = Config.defaultClient();
        }
        Configuration.setDefaultApiClient((ApiClient)this.client);
        this.httpClient = Objects.requireNonNullElseGet(this.httpClient, () -> this.client.getHttpClient().newBuilder().readTimeout(0L, TimeUnit.SECONDS).build());
        this.client.setHttpClient(this.httpClient);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void start() {
        this.executorService.execute(this);
    }

    public void stop() {
        this.executorService.shutdownNow();
    }

    public ApiClient getClient() {
        return this.client;
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setClient(ApiClient client) {
        this.client = client;
    }

    public void setHttpClient(OkHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }
}

