/*
 * Decompiled with CFR 0.152.
 */
package cn.dustlight.jobless.core;

import cn.dustlight.jobless.core.AbstractJobHandler;

public abstract class JobHandlerProvider<T> {
    private JobHandlerUpListener<T> upListener;
    private JobHandlerDownListener downListener;

    protected void callUp(String key, AbstractJobHandler<T> handler) {
        this.upListener.onJobHandlerUp(key, handler);
    }

    protected void callDown(String key) {
        this.downListener.onJobHandlerDown(key);
    }

    public abstract void start();

    public abstract void stop();

    public abstract boolean isClosed();

    public JobHandlerProvider(JobHandlerUpListener<T> upListener, JobHandlerDownListener downListener) {
        this.upListener = upListener;
        this.downListener = downListener;
    }

    public JobHandlerUpListener<T> getUpListener() {
        return this.upListener;
    }

    public JobHandlerDownListener getDownListener() {
        return this.downListener;
    }

    public void setUpListener(JobHandlerUpListener<T> upListener) {
        this.upListener = upListener;
    }

    public void setDownListener(JobHandlerDownListener downListener) {
        this.downListener = downListener;
    }

    public static interface JobHandlerDownListener {
        public void onJobHandlerDown(String var1);
    }

    public static interface JobHandlerUpListener<T> {
        public void onJobHandlerUp(String var1, AbstractJobHandler<T> var2);
    }
}

