/*
 * Decompiled with CFR 0.152.
 */
package cn.dustlight.flow.zeebe.services.usertask;

import cn.dustlight.flow.core.exceptions.ErrorEnum;
import cn.dustlight.flow.core.exceptions.FlowException;
import cn.dustlight.flow.core.flow.QueryResult;
import cn.dustlight.flow.core.flow.usertask.AbstractUserTaskService;
import cn.dustlight.flow.core.flow.usertask.UserTaskDataValidator;
import cn.dustlight.flow.core.flow.usertask.UserTaskService;
import cn.dustlight.flow.zeebe.entities.ZeebeUserTask;
import cn.dustlight.flow.zeebe.entities.ZeebeUserTaskEntity;
import io.camunda.zeebe.client.ZeebeClient;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.Collection;
import java.util.Map;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.PrefixQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.CardinalityAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.ParsedCardinality;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ReactiveElasticsearchOperations;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ZeebeUserTaskService
extends AbstractUserTaskService<ZeebeUserTask>
implements InitializingBean {
    private ReactiveElasticsearchOperations operations;
    private ZeebeClient zeebeClient;
    private String index = "flow-user-task";

    public ZeebeUserTaskService(UserTaskDataValidator validator) {
        super(validator);
    }

    public ZeebeUserTaskService(UserTaskDataValidator validator, ZeebeClient zeebeClient, ReactiveElasticsearchOperations operations) {
        this(validator);
        this.operations = operations;
        this.zeebeClient = zeebeClient;
    }

    protected Mono<Void> doComplete(String clientId, Long id, String user, Map<String, Object> data, ZeebeUserTask userTask) {
        return Mono.create(sink -> sink.onRequest(unused -> this.zeebeClient.newCompleteCommand(userTask.getId().longValue()).variables(data).send().whenComplete((completeJobResponse, throwable) -> {
            if (throwable != null) {
                sink.error((Throwable)(throwable instanceof StatusRuntimeException && ((StatusRuntimeException)throwable).getStatus().getCode().equals((Object)Status.NOT_FOUND.getCode()) ? ErrorEnum.USER_TASK_NOT_FOUND.details(throwable).getException() : ErrorEnum.UNKNOWN.details(throwable).getException()));
            } else {
                sink.success((Object)System.currentTimeMillis());
            }
        }))).onErrorResume(e -> e instanceof FlowException && ((FlowException)e).getErrorDetails().getCode() == ErrorEnum.USER_TASK_NOT_FOUND.getCode() ? this.operations.delete((Object)userTask.entity(), IndexCoordinates.of((String[])new String[]{this.index})).then(Mono.error((Throwable)e)) : Mono.error((Throwable)e)).flatMap(unused -> this.operations.save((Object)userTask.complete(user, data).entity(), IndexCoordinates.of((String[])new String[]{this.index}))).then();
    }

    public Mono<QueryResult<ZeebeUserTask>> getTasks(String clientId, Collection<String> users, Collection<String> roles, UserTaskService.TaskStatus status, int page, int size) {
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        boolQueryBuilder.filter((QueryBuilder)new PrefixQueryBuilder("bpmnProcessId.keyword", String.format("c%s-", clientId)));
        if (users != null && users.size() > 0) {
            boolQueryBuilder.filter((QueryBuilder)new TermsQueryBuilder("target.users", users));
        }
        if (roles != null && roles.size() > 0) {
            boolQueryBuilder.filter((QueryBuilder)new TermsQueryBuilder("target.roles", roles));
        }
        if (status != null) {
            switch (status) {
                case DONE: {
                    boolQueryBuilder.must((QueryBuilder)new ExistsQueryBuilder("doneAt"));
                    break;
                }
                default: {
                    boolQueryBuilder.mustNot((QueryBuilder)new ExistsQueryBuilder("doneAt"));
                }
            }
        }
        NativeSearchQuery query = new NativeSearchQueryBuilder().withQuery((QueryBuilder)boolQueryBuilder).withPageable(Pageable.ofSize((int)size).withPage(page)).addAggregation((AbstractAggregationBuilder)new CardinalityAggregationBuilder("count").field("key")).build();
        return this.operations.searchForPage((Query)query, ZeebeUserTaskEntity.class, IndexCoordinates.of((String[])new String[]{this.index})).flatMap(searchHits -> {
            long count = searchHits.getSearchHits().getAggregations().get("count") instanceof ParsedCardinality ? ((ParsedCardinality)searchHits.getSearchHits().getAggregations().get("count")).getValue() : searchHits.getTotalElements();
            return Flux.fromIterable((Iterable)searchHits.getContent()).map(hit -> new ZeebeUserTask((ZeebeUserTaskEntity)hit.getContent())).collectList().map(zeebeUserTasks -> new QueryResult(count, (Collection)zeebeUserTasks));
        });
    }

    public Mono<ZeebeUserTask> getTask(String clientId, Long id) {
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        boolQueryBuilder.filter((QueryBuilder)new TermQueryBuilder("key", (Object)id)).filter((QueryBuilder)new PrefixQueryBuilder("bpmnProcessId.keyword", String.format("c%s-", clientId)));
        NativeSearchQuery query = new NativeSearchQueryBuilder().withQuery((QueryBuilder)boolQueryBuilder).withPageable(Pageable.ofSize((int)1)).build();
        return this.operations.search((Query)query, ZeebeUserTaskEntity.class, IndexCoordinates.of((String[])new String[]{this.index})).singleOrEmpty().switchIfEmpty(Mono.error((Throwable)ErrorEnum.USER_TASK_NOT_FOUND.getException())).map(zeebeUserTaskEntitySearchHit -> new ZeebeUserTask((ZeebeUserTaskEntity)zeebeUserTaskEntitySearchHit.getContent()));
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.operations, (String)"ReactiveElasticsearchOperations must be set!");
        Assert.notNull((Object)this.zeebeClient, (String)"ZeebeClient must be set!");
    }

    public ReactiveElasticsearchOperations getOperations() {
        return this.operations;
    }

    public ZeebeClient getZeebeClient() {
        return this.zeebeClient;
    }

    public String getIndex() {
        return this.index;
    }

    public void setOperations(ReactiveElasticsearchOperations operations) {
        this.operations = operations;
    }

    public void setZeebeClient(ZeebeClient zeebeClient) {
        this.zeebeClient = zeebeClient;
    }

    public void setIndex(String index) {
        this.index = index;
    }
}

