/*
 * Decompiled with CFR 0.152.
 */
package cn.dustlight.flow.zeebe.services.adapters;

import cn.dustlight.flow.zeebe.services.adapters.AbstractZeebeProcessAdapter;
import cn.dustlight.flow.zeebe.services.adapters.AdapterContext;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeFormDefinition;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeUserTaskForm;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Queue;
import org.springframework.util.StringUtils;

public class UserTaskFormAdapter
extends AbstractZeebeProcessAdapter {
    private String prefix = "camunda-forms:bpmn:";

    @Override
    public void adapt(BpmnModelInstance instance, AdapterContext context) throws Exception {
        Collection formDefinitions;
        Collection zeebeUserTaskForms = instance.getModelElementsByType(ZeebeUserTaskForm.class);
        HashMap userTaskIdMap = new HashMap();
        if (zeebeUserTaskForms != null) {
            zeebeUserTaskForms.forEach(zeebeUserTaskForm -> userTaskIdMap.put(zeebeUserTaskForm.getId(), zeebeUserTaskForm.getRawTextContent()));
        }
        if ((formDefinitions = instance.getModelElementsByType(ZeebeFormDefinition.class)) != null) {
            formDefinitions.forEach(formDefinition -> {
                String form;
                if (!StringUtils.hasText((String)formDefinition.getFormKey()) || !formDefinition.getFormKey().startsWith(this.prefix)) {
                    return;
                }
                String formKey = formDefinition.getFormKey();
                if (formKey.startsWith(this.prefix)) {
                    formKey = formKey.substring(this.prefix.length());
                }
                if ((form = (String)userTaskIdMap.get(formKey)) != null) {
                    formDefinition.setFormKey(form);
                }
            });
        }
    }

    @Override
    public void reverse(BpmnModelInstance instance, AdapterContext context) throws Exception {
        Collection formDefinitions;
        Collection zeebeUserTaskForms = instance.getModelElementsByType(ZeebeUserTaskForm.class);
        HashMap userTaskFormMap = new HashMap();
        if (zeebeUserTaskForms != null) {
            zeebeUserTaskForms.forEach(userTask -> {
                String key = userTask.getRawTextContent();
                LinkedList<String> list = (LinkedList<String>)userTaskFormMap.get(key);
                if (list == null) {
                    list = new LinkedList<String>();
                    userTaskFormMap.put(key, list);
                }
                list.add(userTask.getId());
            });
        }
        if ((formDefinitions = instance.getModelElementsByType(ZeebeFormDefinition.class)) != null) {
            formDefinitions.forEach(formDefinition -> {
                Queue idQueue = (Queue)userTaskFormMap.get(formDefinition.getFormKey());
                if (idQueue == null || idQueue.isEmpty()) {
                    return;
                }
                String id = (String)idQueue.poll();
                formDefinition.setFormKey(String.format("%s%s", this.prefix, id));
            });
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public UserTaskFormAdapter(String prefix) {
        this.prefix = prefix;
    }

    public UserTaskFormAdapter() {
    }
}

