/*
 * Decompiled with CFR 0.152.
 */
package cn.dustlight.flow.zeebe.services.adapters;

import cn.dustlight.flow.zeebe.services.adapters.AbstractZeebeProcessAdapter;
import cn.dustlight.flow.zeebe.services.adapters.AdapterContext;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.instance.BaseElement;
import io.camunda.zeebe.model.bpmn.instance.Message;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeTaskDefinition;
import java.util.Collection;
import java.util.Set;
import org.springframework.util.StringUtils;

public class MultiTenantAdapter
extends AbstractZeebeProcessAdapter {
    private Set<String> systemPrefix;

    @Override
    public void adapt(BpmnModelInstance instance, AdapterContext context) throws Exception {
        Collection messages;
        Collection zeebeTaskDefinitions;
        String prefix = String.format("c%s-", context.getClientId());
        Collection baseElements = instance.getModelElementsByType(BaseElement.class);
        if (baseElements != null) {
            for (BaseElement baseElement : baseElements) {
                if (baseElement.getId() == null) continue;
                baseElement.setId(String.format("%s%s", prefix, baseElement.getId()));
            }
        }
        if ((zeebeTaskDefinitions = instance.getModelElementsByType(ZeebeTaskDefinition.class)) != null) {
            zeebeTaskDefinitions.forEach(zeebeTaskDefinition -> {
                boolean isSystemPrefix = false;
                String type = zeebeTaskDefinition.getType();
                if (this.systemPrefix != null && this.systemPrefix.size() > 0) {
                    for (String p : this.systemPrefix) {
                        if (!type.startsWith(p)) continue;
                        isSystemPrefix = true;
                        break;
                    }
                }
                if (!isSystemPrefix) {
                    zeebeTaskDefinition.setType(String.format("%s%s", prefix, type));
                }
            });
        }
        if ((messages = instance.getModelElementsByType(Message.class)) != null) {
            messages.forEach(message -> {
                if (message.getName() != null) {
                    message.setName(String.format("%s%s", prefix, message.getName()));
                }
            });
        }
    }

    @Override
    public void reverse(BpmnModelInstance instance, AdapterContext context) throws Exception {
        Collection messages;
        Collection zeebeTaskDefinitions;
        String prefix = String.format("c%s-", context.getClientId());
        Collection baseElements = instance.getModelElementsByType(BaseElement.class);
        if (baseElements != null) {
            baseElements.forEach(baseElement -> {
                if (StringUtils.hasText((String)baseElement.getId()) && baseElement.getId().startsWith(prefix)) {
                    baseElement.setId(baseElement.getId().substring(prefix.length()));
                }
            });
        }
        if ((zeebeTaskDefinitions = instance.getModelElementsByType(ZeebeTaskDefinition.class)) != null) {
            zeebeTaskDefinitions.forEach(zeebeTaskDefinition -> {
                if (StringUtils.hasText((String)zeebeTaskDefinition.getType()) && zeebeTaskDefinition.getType().startsWith(prefix)) {
                    zeebeTaskDefinition.setType(zeebeTaskDefinition.getType().substring(prefix.length()));
                }
            });
        }
        if ((messages = instance.getModelElementsByType(Message.class)) != null) {
            messages.forEach(message -> {
                if (StringUtils.hasText((String)message.getName()) && message.getName().startsWith(prefix)) {
                    message.setName(message.getName().substring(prefix.length()));
                }
            });
        }
    }

    public MultiTenantAdapter() {
    }

    public MultiTenantAdapter(Set<String> systemPrefix) {
        this.systemPrefix = systemPrefix;
    }

    public Set<String> getSystemPrefix() {
        return this.systemPrefix;
    }

    public void setSystemPrefix(Set<String> systemPrefix) {
        this.systemPrefix = systemPrefix;
    }
}

