/*
 * Decompiled with CFR 0.152.
 */
package cn.dustlight.flow.zeebe.services;

import cn.dustlight.flow.core.exceptions.ErrorEnum;
import cn.dustlight.flow.core.exceptions.FlowException;
import cn.dustlight.flow.core.flow.QueryResult;
import cn.dustlight.flow.core.flow.process.Process;
import cn.dustlight.flow.core.flow.process.ProcessService;
import cn.dustlight.flow.zeebe.entities.DefaultAdapterContext;
import cn.dustlight.flow.zeebe.entities.ZeebeProcess;
import cn.dustlight.flow.zeebe.entities.ZeebeProcessEntity;
import cn.dustlight.flow.zeebe.services.adapters.ZeebeProcessAdapter;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.PrefixQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.CardinalityAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.ParsedCardinality;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.core.Ordered;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ReactiveElasticsearchOperations;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.FetchSourceFilterBuilder;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ZeebeProcessService
implements ProcessService<String> {
    private ZeebeClient zeebeClient;
    private ReactiveElasticsearchOperations operations;
    private List<ZeebeProcessAdapter> adapters;
    private String processIndex = "zeebe-record-process";
    private static final String ownerPlaceholder = "%s-%s";
    private static final ZeebeProcess zeebeProcessTemplate = new ZeebeProcess();

    public ZeebeProcessService(ZeebeClient zeebeClient, ReactiveElasticsearchOperations elasticsearchOperations) {
        this(zeebeClient, elasticsearchOperations, null);
    }

    public ZeebeProcessService(ZeebeClient zeebeClient, ReactiveElasticsearchOperations elasticsearchOperations, Set<ZeebeProcessAdapter> zeebeProcessAdapters) {
        this.zeebeClient = zeebeClient;
        this.operations = elasticsearchOperations;
        if (zeebeProcessAdapters != null && zeebeProcessAdapters.size() > 0) {
            this.adapters = new ArrayList<ZeebeProcessAdapter>();
            this.adapters.addAll(zeebeProcessAdapters);
            this.adapters.sort(Comparator.comparingInt(Ordered::getOrder));
        }
    }

    public Mono<Process<String>> createProcess(String clientId, String owner, String processData) {
        return this.adapt(clientId, owner, processData).flatMap(s -> Mono.create(sink -> sink.onRequest(unused -> this.zeebeClient.newDeployCommand().addResourceBytes(Base64.getDecoder().decode((String)s), this.computeOwner(clientId, owner)).send().whenComplete((d, e) -> {
            if (e == null) {
                sink.success(d);
            } else {
                sink.error(e);
            }
        }))).map(d -> {
            ZeebeProcessEntity zeebeProcessEntity = new ZeebeProcessEntity();
            ZeebeProcessEntity.Value value = new ZeebeProcessEntity.Value();
            zeebeProcessEntity.setKey(d.getKey());
            zeebeProcessEntity.setValue(value);
            value.setResource(processData);
            return new ZeebeProcess(zeebeProcessEntity);
        }));
    }

    public Mono<Void> deleteProcess(String clientId, String processName) {
        return null;
    }

    public Mono<Process<String>> getProcess(String clientId, String name, Integer version) {
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder().must((QueryBuilder)new TermQueryBuilder("value.bpmnProcessId", String.format("c%s-%s", clientId, name)));
        if (version != null) {
            boolQueryBuilder.filter((QueryBuilder)new MatchQueryBuilder("value.version", (Object)version));
        }
        NativeSearchQuery q = new NativeSearchQueryBuilder().withQuery((QueryBuilder)boolQueryBuilder).withMaxResults(Integer.valueOf(1)).withSort(new FieldSortBuilder("value.version").order(SortOrder.DESC)).build();
        return this.operations.search((Query)q, ZeebeProcessEntity.class, IndexCoordinates.of((String[])new String[]{this.processIndex})).singleOrEmpty().switchIfEmpty(Mono.error((Throwable)ErrorEnum.PROCESS_NOT_FOUND.getException())).map(zeebeProcessEntitySearchHit -> (ZeebeProcessEntity)zeebeProcessEntitySearchHit.getContent()).map(ZeebeProcessService::cloneAndSet).flatMap(this::reverse);
    }

    public Mono<Boolean> isProcessExists(String clientId, Collection<String> name) {
        if (name == null || name.size() == 0) {
            return Mono.just((Object)false);
        }
        HashSet<String> terms = new HashSet<String>();
        for (String n : name) {
            terms.add(String.format("c%s-%s", clientId, n.trim()));
        }
        NativeSearchQuery query = new NativeSearchQueryBuilder().withQuery((QueryBuilder)new BoolQueryBuilder().filter((QueryBuilder)new TermsQueryBuilder("value.bpmnProcessId", terms))).withSourceFilter(new FetchSourceFilterBuilder().withIncludes(new String[]{"value.bpmnProcessId"}).build()).withCollapseField("value.bpmnProcessId").build();
        return this.operations.searchForPage((Query)query, ZeebeProcessEntity.class, IndexCoordinates.of((String[])new String[]{this.processIndex})).map(x -> x.getSize() == name.size());
    }

    public Mono<QueryResult<ZeebeProcess>> findProcess(String clientId, String keyword, int page, int size) {
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder().filter((QueryBuilder)(StringUtils.hasText((String)keyword) ? new MatchQueryBuilder("value.bpmnProcessId", (Object)String.format("c%s-%s", clientId, keyword)) : new MatchAllQueryBuilder())).filter((QueryBuilder)new PrefixQueryBuilder("value.bpmnProcessId", String.format("c%s-", clientId)));
        NativeSearchQuery q = new NativeSearchQueryBuilder().withQuery((QueryBuilder)boolQueryBuilder).withSourceFilter(new FetchSourceFilterBuilder().withExcludes(new String[]{"value.resource"}).build()).withSort(new FieldSortBuilder("position").order(SortOrder.DESC)).withPageable(Pageable.ofSize((int)size).withPage(page)).withCollapseField("value.bpmnProcessId").addAggregation((AbstractAggregationBuilder)new CardinalityAggregationBuilder("count").field("value.bpmnProcessId")).build();
        return this.operations.searchForPage((Query)q, ZeebeProcessEntity.class, IndexCoordinates.of((String[])new String[]{this.processIndex})).flatMap(searchHits -> {
            long count = searchHits.getSearchHits().getAggregations().get("count") instanceof ParsedCardinality ? ((ParsedCardinality)searchHits.getSearchHits().getAggregations().get("count")).getValue() : searchHits.getTotalElements();
            return Flux.fromStream((Stream)searchHits.stream()).map(hit -> (ZeebeProcessEntity)hit.getContent()).map(ZeebeProcessService::cloneAndSet).flatMap(this::reverse).collectList().map(hits -> new QueryResult(count, (Collection)hits));
        });
    }

    protected String computeOwner(String clientId, String val) {
        return String.format(ownerPlaceholder, clientId, val);
    }

    protected Mono<String> adapt(String clientId, String owner, String processData) {
        if (!StringUtils.hasText((String)processData)) {
            return Mono.empty();
        }
        if (this.adapters == null || this.adapters.size() == 0) {
            return Mono.just((Object)processData);
        }
        DefaultAdapterContext context = new DefaultAdapterContext(clientId, owner);
        Mono result = Mono.just((Object)Bpmn.readModelFromStream((InputStream)new ByteArrayInputStream(Base64.getDecoder().decode(processData))));
        for (ZeebeProcessAdapter adapter : this.adapters) {
            result = result.transform(bpmnModelInstanceMono -> bpmnModelInstanceMono.flatMap(instance -> {
                try {
                    adapter.adapt((BpmnModelInstance)instance, context);
                    return Mono.just((Object)instance);
                }
                catch (Exception e) {
                    return Mono.error((Throwable)e);
                }
            }));
        }
        return result.map(instance -> {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Bpmn.writeModelToStream((OutputStream)out, (BpmnModelInstance)instance);
            return Base64.getEncoder().encodeToString(out.toByteArray());
        });
    }

    protected Mono<ZeebeProcess> reverse(ZeebeProcess zeebeProcess) {
        if (this.adapters == null || this.adapters.size() == 0 || !StringUtils.hasText((String)zeebeProcess.getData())) {
            return Mono.just((Object)zeebeProcess);
        }
        DefaultAdapterContext context = new DefaultAdapterContext(zeebeProcess.getClientId(), zeebeProcess.getOwner());
        Mono result = Mono.just((Object)Bpmn.readModelFromStream((InputStream)new ByteArrayInputStream(Base64.getDecoder().decode(zeebeProcess.getData()))));
        for (ZeebeProcessAdapter adapter : this.adapters) {
            result = result.transform(bpmnModelInstanceMono -> bpmnModelInstanceMono.flatMap(instance -> {
                try {
                    adapter.reverse((BpmnModelInstance)instance, context);
                    return Mono.just((Object)instance);
                }
                catch (Exception e) {
                    return Mono.error((Throwable)e);
                }
            }));
        }
        return result.map(instance -> {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Bpmn.writeModelToStream((OutputStream)out, (BpmnModelInstance)instance);
            zeebeProcess.setData(Base64.getEncoder().encodeToString(out.toByteArray()));
            return zeebeProcess;
        });
    }

    private static ZeebeProcess cloneAndSet(ZeebeProcessEntity zeebeProcessEntity) {
        try {
            return ZeebeProcess.cloneAndSet(zeebeProcessTemplate, zeebeProcessEntity);
        }
        catch (CloneNotSupportedException e) {
            throw new FlowException(e.getMessage(), (Throwable)e);
        }
    }

    public String getProcessIndex() {
        return this.processIndex;
    }

    public void setProcessIndex(String processIndex) {
        this.processIndex = processIndex;
    }
}

