/*
 * Decompiled with CFR 0.152.
 */
package cn.dustlight.flow.zeebe.services;

import cn.dustlight.flow.core.exceptions.ErrorEnum;
import cn.dustlight.flow.core.flow.QueryResult;
import cn.dustlight.flow.core.flow.instance.Instance;
import cn.dustlight.flow.core.flow.instance.InstanceEvent;
import cn.dustlight.flow.core.flow.instance.InstanceService;
import cn.dustlight.flow.zeebe.entities.ZeebeInstance;
import cn.dustlight.flow.zeebe.entities.ZeebeInstanceEntity;
import cn.dustlight.flow.zeebe.entities.ZeebeInstanceEvent;
import cn.dustlight.flow.zeebe.entities.ZeebeVariableEntity;
import io.camunda.zeebe.client.ZeebeClient;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.InnerHitBuilder;
import org.elasticsearch.index.query.PrefixQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.CardinalityAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.ParsedCardinality;
import org.elasticsearch.search.collapse.CollapseBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ReactiveElasticsearchOperations;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.FetchSourceFilterBuilder;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ZeebeInstanceService
implements InstanceService {
    private ZeebeClient zeebeClient;
    private ReactiveElasticsearchOperations operations;
    private String instanceIndex = "zeebe-record-process-instance";
    private String incidentIndex = "zeebe-record-incident";
    private String variableIndex = "zeebe-record-variable";

    public ZeebeInstanceService(ZeebeClient zeebeClient, ReactiveElasticsearchOperations operations) {
        this.zeebeClient = zeebeClient;
        this.operations = operations;
    }

    public Mono<Instance> start(String clientId, String name, Map<String, Object> variables) {
        return Mono.create(sink -> sink.onRequest(unused -> this.zeebeClient.newCreateInstanceCommand().bpmnProcessId(String.format("c%s-%s", clientId, name)).latestVersion().variables(variables).send().whenComplete((processInstanceEvent, throwable) -> {
            ZeebeInstanceEntity entity = new ZeebeInstanceEntity();
            entity.setKey(processInstanceEvent.getProcessInstanceKey());
            ZeebeInstanceEntity.Value value = new ZeebeInstanceEntity.Value();
            entity.setValue(value);
            value.setBpmnProcessId(processInstanceEvent.getBpmnProcessId());
            value.setProcessInstanceKey(processInstanceEvent.getProcessInstanceKey());
            value.setVersion(processInstanceEvent.getVersion());
            value.setProcessDefinitionKey(processInstanceEvent.getProcessDefinitionKey());
            if (throwable != null) {
                sink.error(throwable);
            } else {
                sink.success((Object)new ZeebeInstance(entity, null));
            }
        })));
    }

    public Mono<Instance> get(String clientId, Long id) {
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder().filter((QueryBuilder)new PrefixQueryBuilder("value.bpmnProcessId", String.format("c%s-", clientId))).filter((QueryBuilder)new TermQueryBuilder("value.processInstanceKey", (Object)id));
        NativeSearchQuery query = new NativeSearchQueryBuilder().withQuery((QueryBuilder)boolQueryBuilder).withSort(new FieldSortBuilder("timestamp").order(SortOrder.ASC)).withSort(new FieldSortBuilder("position").order(SortOrder.ASC)).build();
        query.setCollapseBuilder(new CollapseBuilder("key").setInnerHits(new InnerHitBuilder().setName("events").setSize(4).addSort(new FieldSortBuilder("timestamp").order(SortOrder.ASC)).addSort(new FieldSortBuilder("position").order(SortOrder.ASC))));
        return this.operations.searchForPage((Query)query, ZeebeInstanceEntity.class, IndexCoordinates.of((String[])new String[]{this.incidentIndex, this.instanceIndex})).flatMapMany(searchHits -> searchHits.hasContent() ? Flux.fromIterable((Iterable)searchHits.getSearchHits()) : Flux.error((Throwable)ErrorEnum.INSTANCE_NOT_FOUND.getException())).map(hit -> {
            ZeebeInstanceEntity start = (ZeebeInstanceEntity)hit.getContent();
            SearchHits currentHits = hit.getInnerHits("events");
            ZeebeInstanceEntity current = currentHits.hasSearchHits() ? (ZeebeInstanceEntity)currentHits.getSearchHit(currentHits.getSearchHits().size() - 1).getContent() : null;
            return new ZeebeInstanceEvent(start, current);
        }).collectList().map(events -> new ZeebeInstance((List<ZeebeInstanceEvent>)events));
    }

    public Mono<QueryResult<Instance>> list(String clientId, String name, Integer version, Set<InstanceEvent.Status> statuses, int page, int size) {
        BoolQueryBuilder statusFilter = null;
        if (statuses != null && !statuses.isEmpty()) {
            statusFilter = new BoolQueryBuilder();
            HashSet<BoolQueryBuilder> statusQueries = new HashSet<BoolQueryBuilder>();
            for (InstanceEvent.Status status : statuses) {
                switch (status) {
                    case ACTIVE: {
                        statusQueries.add(StatusQuery.ACTIVE);
                        break;
                    }
                    case CANCELED: {
                        statusQueries.add(StatusQuery.CANCELED);
                        break;
                    }
                    case COMPLETED: {
                        statusQueries.add(StatusQuery.COMPLETED);
                        break;
                    }
                    case INCIDENT: {
                        statusQueries.add(StatusQuery.INCIDENT);
                        break;
                    }
                }
            }
            for (QueryBuilder queryBuilder : statusQueries) {
                statusFilter.should(queryBuilder);
            }
        }
        return this.listInstance(clientId, name, version, page, size, new QueryBuilder[]{statusFilter});
    }

    public Mono<Void> cancel(String client, Long id) {
        return this.getEntity(client, id, this.instanceIndex).switchIfEmpty(Mono.error((Throwable)ErrorEnum.INSTANCE_NOT_FOUND.getException())).map(entity -> new ZeebeInstance((ZeebeInstanceEntity)entity, (ZeebeInstanceEntity)entity)).flatMap(instance -> Mono.create(sink -> sink.onRequest(unused -> this.zeebeClient.newCancelInstanceCommand(instance.getId().longValue()).send().whenComplete((unused2, e) -> {
            if (e == null) {
                sink.success();
            } else {
                sink.error(e);
            }
        }))));
    }

    public Mono<Void> resolve(String client, Long id, Long scope) {
        return this.getEntity(client, id, this.instanceIndex).switchIfEmpty(Mono.error((Throwable)ErrorEnum.INSTANCE_NOT_FOUND.getException())).map(entity -> new ZeebeInstanceEvent((ZeebeInstanceEntity)entity, (ZeebeInstanceEntity)entity)).flatMap(instance -> Mono.create(sink -> sink.onRequest(unused -> this.zeebeClient.newResolveIncidentCommand(scope.longValue()).send().whenComplete((unused2, e) -> {
            if (e == null) {
                sink.success();
            } else {
                sink.error(e);
            }
        }))));
    }

    public Mono<Map<String, Object>> getVariables(String client, Long id, Long scope) {
        NativeSearchQuery query = new NativeSearchQueryBuilder().withQuery((QueryBuilder)new BoolQueryBuilder().filter((QueryBuilder)new PrefixQueryBuilder("value.bpmnProcessId", String.format("c%s-", client))).filter((QueryBuilder)new TermQueryBuilder("value.processInstanceKey", (Object)id))).withPageable(Pageable.ofSize((int)1)).build();
        return this.operations.search((Query)query, ZeebeInstanceEntity.class, IndexCoordinates.of((String[])new String[]{this.instanceIndex})).singleOrEmpty().switchIfEmpty(Mono.error((Throwable)ErrorEnum.INSTANCE_NOT_FOUND.getException())).map(hit -> (ZeebeInstanceEntity)hit.getContent()).map(entity -> new NativeSearchQueryBuilder().withQuery((QueryBuilder)new BoolQueryBuilder().filter((QueryBuilder)new TermQueryBuilder("value.processInstanceKey", (Object)entity.getKey())).filter((QueryBuilder)new TermQueryBuilder("value.scopeKey", (Object)scope))).build()).flatMapMany(nativeSearchQuery -> this.operations.search((Query)nativeSearchQuery, ZeebeVariableEntity.class, IndexCoordinates.of((String[])new String[]{this.variableIndex}))).map(zeebeVariableEntitySearchHit -> (ZeebeVariableEntity)zeebeVariableEntitySearchHit.getContent()).collectList().map(zeebeVariableEntities -> {
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (ZeebeVariableEntity zeebeVariable : zeebeVariableEntities) {
                ZeebeVariableEntity.Value value;
                if (zeebeVariable == null || (value = zeebeVariable.getValue()) == null) continue;
                result.put(value.getName(), value.getValue());
            }
            return result;
        });
    }

    public Mono<Void> setVariables(String client, Long id, Long scope, Map<String, Object> variables) {
        return this.getEntity(client, id, this.instanceIndex).switchIfEmpty(Mono.error((Throwable)ErrorEnum.INSTANCE_NOT_FOUND.getException())).map(entity -> new ZeebeInstanceEvent((ZeebeInstanceEntity)entity, (ZeebeInstanceEntity)entity)).flatMap(instance -> Mono.create(sink -> sink.onRequest(unused -> this.zeebeClient.newSetVariablesCommand(scope.longValue()).variables(variables).local(instance.getId() == scope).send().whenComplete((unused2, e) -> {
            if (e == null) {
                sink.success();
            } else {
                sink.error(e);
            }
        }))));
    }

    public Mono<QueryResult<Instance>> listInstance(String clientId, String name, Integer version, int page, int size, QueryBuilder ... filters) {
        TermQueryBuilder processId = StringUtils.hasText((String)name) ? new TermQueryBuilder("value.bpmnProcessId", String.format("c%s-%s", clientId, name)) : new PrefixQueryBuilder("value.bpmnProcessId", String.format("c%s-", clientId));
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder().filter((QueryBuilder)processId);
        if (version != null) {
            boolQueryBuilder.filter((QueryBuilder)new TermQueryBuilder("value.version", (Object)version));
        }
        if (filters != null) {
            for (QueryBuilder f : filters) {
                if (f == null) continue;
                boolQueryBuilder.filter(f);
            }
        }
        NativeSearchQuery query = new NativeSearchQueryBuilder().withQuery((QueryBuilder)boolQueryBuilder).withSourceFilter(new FetchSourceFilterBuilder().build()).withPageable(Pageable.ofSize((int)size).withPage(page)).addAggregation((AbstractAggregationBuilder)new CardinalityAggregationBuilder("count").field("value.processInstanceKey")).build();
        query.setCollapseBuilder(new CollapseBuilder("value.processInstanceKey").setInnerHits(Arrays.asList(new InnerHitBuilder().setName("current").setSize(1).addSort(new FieldSortBuilder("position").order(SortOrder.DESC)), new InnerHitBuilder().setName("start").setSize(1).addSort(new FieldSortBuilder("position").order(SortOrder.ASC)))));
        return this.operations.searchForPage((Query)query, ZeebeInstanceEntity.class, IndexCoordinates.of((String[])new String[]{this.incidentIndex, this.instanceIndex})).flatMap(searchHits -> {
            long count = searchHits.getSearchHits().getAggregations().get("count") instanceof ParsedCardinality ? ((ParsedCardinality)searchHits.getSearchHits().getAggregations().get("count")).getValue() : searchHits.getTotalElements();
            return Flux.fromIterable((Iterable)searchHits.getContent()).map(hit -> {
                ZeebeInstanceEntity start = (ZeebeInstanceEntity)hit.getInnerHits("start").getSearchHit(0).getContent();
                SearchHits currentHits = hit.getInnerHits("current");
                ZeebeInstanceEntity current = currentHits.hasSearchHits() ? (ZeebeInstanceEntity)currentHits.getSearchHit(0).getContent() : null;
                return new ZeebeInstance(start, current);
            }).collectList().map(hits -> new QueryResult(count, (Collection)hits));
        });
    }

    protected Mono<ZeebeInstanceEntity> getEntity(String clientId, Long key, String ... index) {
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder().filter((QueryBuilder)new PrefixQueryBuilder("value.bpmnProcessId", String.format("c%s-", clientId))).filter((QueryBuilder)new TermQueryBuilder("key", (Object)key));
        NativeSearchQuery query = new NativeSearchQueryBuilder().withQuery((QueryBuilder)boolQueryBuilder).withPageable(Pageable.ofSize((int)1)).build();
        return this.operations.searchForPage((Query)query, ZeebeInstanceEntity.class, IndexCoordinates.of((String[])index)).flatMapMany(searchHits -> searchHits.hasContent() ? Flux.fromIterable((Iterable)searchHits.getSearchHits()) : Flux.empty()).singleOrEmpty().map(zeebeInstanceEntitySearchHit -> (ZeebeInstanceEntity)zeebeInstanceEntitySearchHit.getContent());
    }

    public String getInstanceIndex() {
        return this.instanceIndex;
    }

    public void setInstanceIndex(String instanceIndex) {
        this.instanceIndex = instanceIndex;
    }

    public String getIncidentIndex() {
        return this.incidentIndex;
    }

    public void setIncidentIndex(String incidentIndex) {
        this.incidentIndex = incidentIndex;
    }

    public String getVariableIndex() {
        return this.variableIndex;
    }

    public void setVariableIndex(String variableIndex) {
        this.variableIndex = variableIndex;
    }

    protected static class StatusQuery {
        public static BoolQueryBuilder CANCELED = new BoolQueryBuilder().must((QueryBuilder)new TermQueryBuilder("value.bpmnElementType", "PROCESS")).must((QueryBuilder)new TermQueryBuilder("intent", "ELEMENT_TERMINATED"));
        public static BoolQueryBuilder COMPLETED = new BoolQueryBuilder().must((QueryBuilder)new TermQueryBuilder("value.bpmnElementType", "PROCESS")).must((QueryBuilder)new TermQueryBuilder("intent", "ELEMENT_COMPLETED"));
        public static BoolQueryBuilder INCIDENT = new BoolQueryBuilder().must((QueryBuilder)new TermQueryBuilder("valueType", "INCIDENT")).mustNot((QueryBuilder)new TermQueryBuilder("intent", "RESOLVED"));
        public static BoolQueryBuilder ACTIVE = new BoolQueryBuilder().mustNot((QueryBuilder)CANCELED).mustNot((QueryBuilder)COMPLETED);

        protected StatusQuery() {
        }
    }
}

