/*
 * Decompiled with CFR 0.152.
 */
package cn.dustlight.flow.zeebe.entities;

import cn.dustlight.flow.core.flow.usertask.DefaultUserTarget;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import java.time.Instant;
import java.util.HashSet;
import java.util.Map;
import org.springframework.data.annotation.Id;
import org.springframework.util.StringUtils;

public class ZeebeUserTaskEntity
implements Cloneable {
    private static final ZeebeUserTaskEntity t = new ZeebeUserTaskEntity();
    static final String TARGET_USERS = "dustlight.flow:users";
    static final String TARGET_ROLES = "dustlight.flow:roles";
    static final String FORM_KEY = "io.camunda.zeebe:formKey";
    @Id
    private long key;
    private Map<String, String> customHeaders;
    private long processInstanceKey;
    private String bpmnProcessId;
    private int processDefinitionVersion;
    private long processDefinitionKey;
    private String elementId;
    private long elementInstanceKey;
    private int retries;
    private long deadline;
    private Map<String, Object> variables;
    private DefaultUserTarget target;
    private String doneBy;
    private Instant doneAt;
    private Map<String, Object> data;

    public static ZeebeUserTaskEntity fromJob(ActivatedJob job) {
        Object val;
        int i;
        ZeebeUserTaskEntity instance = (ZeebeUserTaskEntity)t.clone();
        instance.key = job.getKey();
        instance.customHeaders = job.getCustomHeaders();
        instance.processInstanceKey = job.getProcessInstanceKey();
        instance.bpmnProcessId = job.getBpmnProcessId();
        instance.processDefinitionVersion = job.getProcessDefinitionVersion();
        instance.processDefinitionKey = job.getProcessDefinitionKey();
        instance.elementId = job.getElementId();
        instance.elementInstanceKey = job.getElementInstanceKey();
        instance.retries = job.getRetries();
        instance.deadline = job.getDeadline();
        instance.variables = job.getVariablesAsMap();
        Map headers = job.getCustomHeaders();
        String targetUsers = (String)headers.get(TARGET_USERS);
        String targetRoles = (String)headers.get(TARGET_ROLES);
        instance.target = new DefaultUserTarget();
        if (StringUtils.hasText((String)targetUsers)) {
            String[] users = targetUsers.split(",");
            HashSet<String> us = new HashSet<String>();
            for (i = 0; i < users.length; ++i) {
                users[i] = users[i].trim();
                if (users[i].startsWith("=")) {
                    val = instance.variables.get(users[i].substring(1));
                    users[i] = val != null ? val.toString() : null;
                }
                if (!StringUtils.hasText((String)users[i])) continue;
                us.add(users[i]);
            }
            if (us.size() > 0) {
                instance.target.setUsers(us);
            }
        }
        if (StringUtils.hasText((String)targetRoles)) {
            String[] roles = targetRoles.split(",");
            HashSet<String> rs = new HashSet<String>();
            for (i = 0; i < roles.length; ++i) {
                roles[i] = roles[i].trim();
                if (roles[i].startsWith("=")) {
                    val = instance.variables.get(roles[i].substring(1));
                    roles[i] = val != null ? val.toString() : null;
                }
                if (!StringUtils.hasText((String)roles[i])) continue;
                rs.add(roles[i]);
            }
            if (rs.size() > 0) {
                instance.target.setRoles(rs);
            }
        }
        return instance;
    }

    public long getKey() {
        return this.key;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    public int getProcessDefinitionVersion() {
        return this.processDefinitionVersion;
    }

    public long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public String getElementId() {
        return this.elementId;
    }

    public long getElementInstanceKey() {
        return this.elementInstanceKey;
    }

    public int getRetries() {
        return this.retries;
    }

    public long getDeadline() {
        return this.deadline;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public DefaultUserTarget getTarget() {
        return this.target;
    }

    public String getDoneBy() {
        return this.doneBy;
    }

    public Instant getDoneAt() {
        return this.doneAt;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public void setKey(long key) {
        this.key = key;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders = customHeaders;
    }

    public void setProcessInstanceKey(long processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
    }

    public void setBpmnProcessId(String bpmnProcessId) {
        this.bpmnProcessId = bpmnProcessId;
    }

    public void setProcessDefinitionVersion(int processDefinitionVersion) {
        this.processDefinitionVersion = processDefinitionVersion;
    }

    public void setProcessDefinitionKey(long processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public void setElementId(String elementId) {
        this.elementId = elementId;
    }

    public void setElementInstanceKey(long elementInstanceKey) {
        this.elementInstanceKey = elementInstanceKey;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public void setDeadline(long deadline) {
        this.deadline = deadline;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public void setTarget(DefaultUserTarget target) {
        this.target = target;
    }

    public void setDoneBy(String doneBy) {
        this.doneBy = doneBy;
    }

    public void setDoneAt(Instant doneAt) {
        this.doneAt = doneAt;
    }

    public void setData(Map<String, Object> data) {
        this.data = data;
    }
}

