/*
 * Decompiled with CFR 0.152.
 */
package cn.dustlight.flow.zeebe.entities;

import cn.dustlight.flow.core.flow.process.Process;
import cn.dustlight.flow.zeebe.entities.ZeebeProcessEntity;
import java.time.Instant;
import org.springframework.util.StringUtils;

public class ZeebeProcess
implements Process<String>,
Cloneable {
    private ZeebeProcessEntity zeebeProcess;

    public Instant getCreatedAt() {
        return this.zeebeProcess == null || this.zeebeProcess.getTimestamp() == null ? null : Instant.ofEpochMilli(this.zeebeProcess.getTimestamp());
    }

    public Integer getVersion() {
        return this.zeebeProcess == null || this.zeebeProcess.getValue() == null ? null : this.zeebeProcess.getValue().getVersion();
    }

    public Long getId() {
        return this.zeebeProcess == null ? null : this.zeebeProcess.getKey();
    }

    public String getName() {
        if (this.zeebeProcess == null || this.zeebeProcess.getValue() == null) {
            return null;
        }
        ZeebeProcessEntity.Value value = this.zeebeProcess.getValue();
        String str = value.getBpmnProcessId();
        if (!StringUtils.hasText((String)str)) {
            return null;
        }
        return ZeebeProcess.getSuffix(str, '-');
    }

    public String getClientId() {
        if (this.zeebeProcess == null || this.zeebeProcess.getValue() == null) {
            return null;
        }
        ZeebeProcessEntity.Value value = this.zeebeProcess.getValue();
        String str = value.getBpmnProcessId();
        if (!StringUtils.hasText((String)str) || !StringUtils.hasText((String)(str = value.getResourceName()))) {
            return null;
        }
        String prefix = ZeebeProcess.getPrefix(str, '-');
        if (prefix == null) {
            return null;
        }
        return prefix.startsWith("c") ? prefix.substring(1) : prefix;
    }

    public String getOwner() {
        if (this.zeebeProcess == null || this.zeebeProcess.getValue() == null) {
            return null;
        }
        ZeebeProcessEntity.Value value = this.zeebeProcess.getValue();
        String str = value.getResourceName();
        if (!StringUtils.hasText((String)str)) {
            return null;
        }
        String clientId = this.getClientId();
        if (!StringUtils.hasText((String)clientId)) {
            return str;
        }
        return str.startsWith(clientId) ? str.substring(clientId.length() + 2) : str;
    }

    public String getData() {
        return this.zeebeProcess == null || this.zeebeProcess.getValue() == null ? null : this.zeebeProcess.getValue().getResource();
    }

    public void setData(String data) {
        if (this.zeebeProcess == null) {
            this.zeebeProcess = new ZeebeProcessEntity();
        }
        if (this.zeebeProcess.getValue() == null) {
            this.zeebeProcess.setValue(new ZeebeProcessEntity.Value());
        }
        ZeebeProcessEntity.Value value = this.zeebeProcess.getValue();
        value.setResource(data);
    }

    protected static String getPrefix(String target, char split) {
        if (target == null) {
            return null;
        }
        int index = target.indexOf(split);
        if (index == -1) {
            return null;
        }
        return target.substring(0, index);
    }

    protected static String getSuffix(String target, char split) {
        if (target == null) {
            return null;
        }
        int index = target.indexOf(split);
        if (index == -1) {
            return null;
        }
        return target.substring(index + 1);
    }

    protected ZeebeProcess clone() throws CloneNotSupportedException {
        return (ZeebeProcess)super.clone();
    }

    public static ZeebeProcess cloneAndSet(ZeebeProcess template, ZeebeProcessEntity entity) throws CloneNotSupportedException {
        ZeebeProcess instance = template.clone();
        instance.zeebeProcess = entity;
        return instance;
    }

    public ZeebeProcess(ZeebeProcessEntity zeebeProcess) {
        this.zeebeProcess = zeebeProcess;
    }

    public ZeebeProcess() {
    }
}

