/*
 * Decompiled with CFR 0.152.
 */
package cn.dustlight.flow.zeebe.entities;

import cn.dustlight.flow.core.flow.instance.InstanceError;
import cn.dustlight.flow.core.flow.instance.InstanceEvent;
import cn.dustlight.flow.zeebe.entities.ZeebeInstanceEntity;
import cn.dustlight.flow.zeebe.entities.ZeebeInstanceError;
import cn.dustlight.flow.zeebe.entities.ZeebeProcess;
import java.time.Instant;
import java.util.Collection;
import java.util.Set;
import org.springframework.util.StringUtils;

public class ZeebeInstanceEvent
implements InstanceEvent,
Cloneable {
    protected ZeebeInstanceEntity start;
    protected ZeebeInstanceEntity current;
    public static final Collection<String> VALUE_TYPE_ERROR = Set.of("ERROR", "INCIDENT");
    public static final Collection<String> INCIDENT_RESOLVED = Set.of("RESOLVED");
    public static final Collection<String> INTENT_COMPLETED = Set.of("ELEMENT_COMPLETED", "SEQUENCE_FLOW_TAKEN");
    public static final Collection<String> INTENT_CANCELED = Set.of("ELEMENT_TERMINATED");

    public Long getId() {
        return this.start == null ? null : this.start.getKey();
    }

    public String getElementType() {
        return this.start == null || this.start.getValue() == null ? null : this.start.getValue().getBpmnElementType();
    }

    public String getElementId() {
        return ZeebeProcess.getSuffix(this.start == null || this.start.getValue() == null ? null : this.start.getValue().getElementId(), '-');
    }

    public InstanceEvent.Status getStatus() {
        if (this.current == null) {
            return this.start == null ? null : InstanceEvent.Status.ACTIVE;
        }
        String intent = this.current.getIntent();
        String valueType = this.current.getValueType();
        if (VALUE_TYPE_ERROR.contains(valueType)) {
            return INCIDENT_RESOLVED.contains(intent) ? InstanceEvent.Status.RESOLVED : InstanceEvent.Status.INCIDENT;
        }
        if (INTENT_COMPLETED.contains(intent)) {
            return InstanceEvent.Status.COMPLETED;
        }
        if (INTENT_CANCELED.contains(intent)) {
            return InstanceEvent.Status.CANCELED;
        }
        return InstanceEvent.Status.ACTIVE;
    }

    public Instant getCreatedAt() {
        return this.start == null || this.start.getTimestamp() == null ? null : Instant.ofEpochMilli(this.start.getTimestamp());
    }

    public Instant getUpdatedAt() {
        return this.current == null || this.current.getTimestamp() == null ? null : Instant.ofEpochMilli(this.current.getTimestamp());
    }

    public InstanceError getError() {
        ZeebeInstanceEntity.Value value;
        return this.current == null || (value = this.current.getValue()) == null || !StringUtils.hasText((String)value.getErrorMessage()) && !StringUtils.hasText((String)value.getErrorType()) ? null : new ZeebeInstanceError(value.getErrorMessage(), value.getErrorType());
    }

    protected ZeebeInstanceEvent clone() throws CloneNotSupportedException {
        return (ZeebeInstanceEvent)super.clone();
    }

    public ZeebeInstanceEvent() {
    }

    public ZeebeInstanceEvent(ZeebeInstanceEntity start, ZeebeInstanceEntity current) {
        this.start = start;
        this.current = current;
    }
}

