/*
 * Decompiled with CFR 0.152.
 */
package cn.dustlight.flow.zeebe.entities;

import cn.dustlight.flow.core.flow.instance.Instance;
import cn.dustlight.flow.core.flow.instance.InstanceEvent;
import cn.dustlight.flow.zeebe.entities.ZeebeInstanceEntity;
import cn.dustlight.flow.zeebe.entities.ZeebeInstanceEvent;
import cn.dustlight.flow.zeebe.entities.ZeebeProcess;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import org.springframework.util.StringUtils;

public class ZeebeInstance
extends ZeebeInstanceEvent
implements Instance<ZeebeInstanceEvent> {
    private List<ZeebeInstanceEvent> events;

    public ZeebeInstance(List<ZeebeInstanceEvent> events) {
        this.events = events;
        if (events != null && events.size() > 0) {
            events.forEach(event -> {
                ZeebeInstanceEntity eventCurrent;
                ZeebeInstanceEntity eventStart;
                ZeebeInstanceEntity zeebeInstanceEntity = eventStart = event == null || event.start == null ? null : event.start;
                Object object = event == null ? null : (event.current == null ? (event.start == null ? null : event.start) : (eventCurrent = event.current));
                if (this.start == null || eventStart != null && eventStart.getTimestamp() != null && eventStart.getTimestamp() <= this.start.getTimestamp() && eventStart.getPosition() != null && eventStart.getPosition() < this.start.getPosition()) {
                    this.start = eventStart;
                }
                if (this.current == null || eventCurrent != null && eventCurrent.getTimestamp() != null && eventCurrent.getTimestamp() >= this.current.getTimestamp() && eventCurrent.getPosition() != null && eventCurrent.getPosition() > this.current.getPosition()) {
                    this.current = eventCurrent;
                }
            });
        }
    }

    public ZeebeInstance(ZeebeInstanceEntity start, ZeebeInstanceEntity current) {
        super(start, current);
    }

    public Integer getVersion() {
        return this.start == null || this.start.getValue() == null ? null : this.start.getValue().getVersion();
    }

    @Override
    @JsonIgnore
    public String getElementType() {
        return super.getElementType();
    }

    @Override
    @JsonIgnore
    public String getElementId() {
        return super.getElementId();
    }

    @Override
    public InstanceEvent.Status getStatus() {
        String eType;
        if (this.current == null) {
            return this.start == null ? null : InstanceEvent.Status.ACTIVE;
        }
        String intent = this.current.getIntent();
        String valueType = this.current.getValueType();
        if (VALUE_TYPE_ERROR.contains(valueType)) {
            return InstanceEvent.Status.INCIDENT;
        }
        ZeebeInstanceEntity.Value value = this.current.getValue();
        if (value != null && "PROCESS".equals(eType = value.getBpmnElementType())) {
            if (INTENT_COMPLETED.contains(intent)) {
                return InstanceEvent.Status.COMPLETED;
            }
            if (INTENT_CANCELED.contains(intent)) {
                return InstanceEvent.Status.CANCELED;
            }
        }
        return InstanceEvent.Status.ACTIVE;
    }

    public String getName() {
        if (this.start == null || this.start.getValue() == null) {
            return null;
        }
        ZeebeInstanceEntity.Value value = this.start.getValue();
        String str = value.getBpmnProcessId();
        if (!StringUtils.hasText((String)str)) {
            return null;
        }
        return ZeebeProcess.getSuffix(str, '-');
    }

    public String getClientId() {
        if (this.start == null || this.start.getValue() == null) {
            return null;
        }
        ZeebeInstanceEntity.Value value = this.start.getValue();
        String str = value.getBpmnProcessId();
        if (!StringUtils.hasText((String)str)) {
            return null;
        }
        String prefix = ZeebeProcess.getPrefix(str, '-');
        if (prefix == null) {
            return null;
        }
        return prefix.startsWith("c") ? prefix.substring(1) : prefix;
    }

    public List<ZeebeInstanceEvent> getEvents() {
        return this.events;
    }

    public void setEvents(List<ZeebeInstanceEvent> events) {
        this.events = events;
    }

    public ZeebeInstance() {
    }
}

