/*
 * Decompiled with CFR 0.152.
 */
package cn.dustlight.flow.zeebe.converters;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.command.InternalClientException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class ZeebeObjectMapperCover
implements JsonMapper {
    private static final TypeReference<Map<String, Object>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};
    private static final TypeReference<Map<String, String>> STRING_MAP_TYPE_REFERENCE = new TypeReference<Map<String, String>>(){};
    private final ObjectMapper objectMapper;

    public ZeebeObjectMapperCover(ObjectMapper mapper) {
        this.objectMapper = mapper;
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public <T> T fromJson(String json, Class<T> typeClass) {
        try {
            return (T)this.objectMapper.readValue(json, typeClass);
        }
        catch (IOException e) {
            throw new InternalClientException(String.format("Failed to deserialize json '%s' to class '%s'", json, typeClass), (Throwable)e);
        }
    }

    public Map<String, Object> fromJsonAsMap(String json) {
        try {
            return (Map)this.objectMapper.readValue(json, MAP_TYPE_REFERENCE);
        }
        catch (IOException e) {
            throw new InternalClientException(String.format("Failed to deserialize json '%s' to 'Map<String, Object>'", json), (Throwable)e);
        }
    }

    public Map<String, String> fromJsonAsStringMap(String json) {
        try {
            return (Map)this.objectMapper.readValue(json, STRING_MAP_TYPE_REFERENCE);
        }
        catch (IOException e) {
            throw new InternalClientException(String.format("Failed to deserialize json '%s' to 'Map<String, String>'", json), (Throwable)e);
        }
    }

    public String toJson(Object value) {
        try {
            return this.objectMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new InternalClientException(String.format("Failed to serialize object '%s' to json", value), (Throwable)e);
        }
    }

    public String validateJson(String propertyName, String jsonInput) {
        try {
            return this.objectMapper.readTree(jsonInput).toString();
        }
        catch (IOException e) {
            throw new InternalClientException(String.format("Failed to validate json input '%s' for property '%s'", jsonInput, propertyName), (Throwable)e);
        }
    }

    public String validateJson(String propertyName, InputStream jsonInput) {
        try {
            return this.objectMapper.readTree(jsonInput).toString();
        }
        catch (IOException e) {
            throw new InternalClientException(String.format("Failed to validate json input stream for property '%s'", propertyName), (Throwable)e);
        }
    }
}

