/*
 * Decompiled with CFR 0.152.
 */
package cn.dustlight.flow.zeebe.services.usertask;

import cn.dustlight.flow.zeebe.entities.ZeebeUserTaskEntity;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.worker.JobClient;
import io.camunda.zeebe.client.api.worker.JobHandler;
import io.camunda.zeebe.client.api.worker.JobWorker;
import java.time.Duration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.elasticsearch.core.ReactiveElasticsearchOperations;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;

public class UserTaskWorker
implements JobHandler {
    private ZeebeClient zeebeClient;
    private String jobType = "io.camunda.zeebe:userTask";
    private String workerName = "UserTask";
    private JobWorker worker;
    private ReactiveElasticsearchOperations operations;
    private String index = "flow-user-task";
    private static final Log logger = LogFactory.getLog(UserTaskWorker.class);

    public UserTaskWorker(ZeebeClient zeebeClient, ReactiveElasticsearchOperations elasticsearchOperations) {
        this.zeebeClient = zeebeClient;
        this.operations = elasticsearchOperations;
    }

    public void start() {
        if (this.isRunning()) {
            return;
        }
        this.worker = this.zeebeClient.newWorker().jobType(this.jobType).handler(this::handle).name(this.workerName).timeout(Duration.ofSeconds(10L)).open();
    }

    public void stop() {
        if (this.isRunning()) {
            this.worker.close();
        }
    }

    public boolean isRunning() {
        return this.worker != null && this.worker.isOpen();
    }

    public void handle(JobClient client, ActivatedJob job) throws Exception {
        try {
            ZeebeUserTaskEntity instance = ZeebeUserTaskEntity.fromJob(job);
            this.operations.save((Object)instance, IndexCoordinates.of((String[])new String[]{this.index})).block();
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
            client.newThrowErrorCommand(job.getKey()).errorCode("Fail to save job into es.").errorMessage(e.getMessage()).send().join();
        }
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }
}

