/*
 * Decompiled with CFR 0.152.
 */
package cn.dustlight.flow.triggers.sotre.elasticsearch;

import cn.dustlight.flow.core.flow.trigger.TriggerStore;
import cn.dustlight.flow.triggers.sotre.elasticsearch.ElasticsearchTriggerEntity;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.springframework.data.elasticsearch.core.ReactiveElasticsearchOperations;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ElasticsearchTriggerStore
implements TriggerStore {
    private ReactiveElasticsearchOperations operations;
    private String index;

    public Mono<Void> setSubscription(String clientId, String key, String operation, Set<String> process) {
        return this.operations.save((Object)new ElasticsearchTriggerEntity(key, operation, clientId, process), IndexCoordinates.of((String[])new String[]{this.index})).then();
    }

    public Flux<String> getProcess(String clientId, String key, String operation) {
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder().filter((QueryBuilder)new TermQueryBuilder("clientId.keyword", clientId)).filter((QueryBuilder)new TermQueryBuilder("key.keyword", key));
        if (StringUtils.hasText((String)operation)) {
            boolQueryBuilder.filter((QueryBuilder)new TermQueryBuilder("operation.keyword", operation));
        }
        return this.operations.search((Query)new NativeSearchQuery((QueryBuilder)boolQueryBuilder), ElasticsearchTriggerEntity.class, IndexCoordinates.of((String[])new String[]{this.index})).map(elasticsearchTriggerEntitySearchHit -> (ElasticsearchTriggerEntity)elasticsearchTriggerEntitySearchHit.getContent()).map(elasticsearchTriggerEntity -> elasticsearchTriggerEntity.getProcess()).collectList().flatMapMany(sets -> {
            HashSet result = new HashSet();
            sets.forEach(strings -> result.addAll(strings));
            return Flux.fromIterable(result);
        });
    }

    public Flux<String> getSubscription(String clientId, String process, String operation) {
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder().filter((QueryBuilder)new TermQueryBuilder("clientId.keyword", clientId)).filter((QueryBuilder)new TermsQueryBuilder("process.keyword", new String[]{process}));
        if (StringUtils.hasText((String)operation)) {
            boolQueryBuilder.filter((QueryBuilder)new TermQueryBuilder("operation.keyword", operation));
        }
        return this.operations.search((Query)new NativeSearchQuery((QueryBuilder)boolQueryBuilder), ElasticsearchTriggerEntity.class, IndexCoordinates.of((String[])new String[]{this.index})).map(elasticsearchTriggerEntitySearchHit -> (ElasticsearchTriggerEntity)elasticsearchTriggerEntitySearchHit.getContent()).map(elasticsearchTriggerEntity -> elasticsearchTriggerEntity.getKey()).collectList().flatMapMany(key -> {
            HashSet result = new HashSet();
            result.addAll(key);
            return Flux.fromIterable(result);
        });
    }

    public Flux<String> getProcess(String clientId, String key) {
        return this.getProcess(clientId, key, null);
    }

    public Flux<String> getSubscription(String clientId, String process) {
        return this.getSubscription(clientId, process, null);
    }

    public ReactiveElasticsearchOperations getOperations() {
        return this.operations;
    }

    public String getIndex() {
        return this.index;
    }

    public void setOperations(ReactiveElasticsearchOperations operations) {
        this.operations = operations;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public ElasticsearchTriggerStore(ReactiveElasticsearchOperations operations, String index) {
        this.operations = operations;
        this.index = index;
    }
}

