/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.support;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aot.StaticSpringFactories;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.lang.Nullable;
import org.springframework.nativex.AotModeDetector;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class SpringFactoriesLoader {
    private static final Log logger = LogFactory.getLog(SpringFactoriesLoader.class);
    public static final String FACTORIES_RESOURCE_LOCATION = "META-INF/spring.factories";
    static final Map<ClassLoader, Map<String, List<String>>> cache = new ConcurrentReferenceHashMap();

    private SpringFactoriesLoader() {
    }

    public static <T> List<T> loadFactories(Class<T> factoryType, @Nullable ClassLoader classLoader) {
        Assert.notNull(factoryType, (String)"'factoryType' must not be null");
        if (AotModeDetector.isAotModeEnabled()) {
            List result = (List)StaticSpringFactories.factories.get(factoryType);
            if (result == null) {
                return new ArrayList(0);
            }
            ArrayList factories = new ArrayList(result.size());
            for (Supplier supplier : result) {
                try {
                    factories.add(supplier.get());
                }
                catch (Throwable throwable) {
                    logger.trace((Object)("Could not instantiate factory for " + factoryType), throwable);
                }
            }
            return factories;
        }
        ClassLoader classLoaderToUse = classLoader;
        if (classLoaderToUse == null) {
            classLoaderToUse = SpringFactoriesLoader.class.getClassLoader();
        }
        List factoryImplementationNames = SpringFactoriesLoader.loadFactoryNames(factoryType, (ClassLoader)classLoaderToUse);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Loaded [" + factoryType.getName() + "] names: " + factoryImplementationNames));
        }
        ArrayList<Object> result = new ArrayList<Object>(factoryImplementationNames.size());
        for (String factoryImplementationName : factoryImplementationNames) {
            result.add(SpringFactoriesLoader.instantiateFactory((String)factoryImplementationName, factoryType, (ClassLoader)classLoaderToUse));
        }
        AnnotationAwareOrderComparator.sort(result);
        return result;
    }

    public static List<String> loadFactoryNames(Class<?> factoryType, @Nullable ClassLoader classLoader) {
        if (AotModeDetector.isAotModeEnabled()) {
            List stored;
            ArrayList<String> result = new ArrayList<String>();
            List names = (List)StaticSpringFactories.names.get(factoryType);
            if (names != null) {
                result.addAll(names);
            }
            if ((stored = (List)StaticSpringFactories.factories.get(factoryType)) != null) {
                for (Supplier supplier : stored) {
                    try {
                        result.add(supplier.get().getClass().getName());
                    }
                    catch (Throwable throwable) {
                        logger.trace((Object)("Could not get factory name for " + factoryType), throwable);
                    }
                }
            }
            return result;
        }
        ClassLoader classLoaderToUse = classLoader;
        if (classLoaderToUse == null) {
            classLoaderToUse = SpringFactoriesLoader.class.getClassLoader();
        }
        String factoryTypeName = factoryType.getName();
        return SpringFactoriesLoader.loadSpringFactories((ClassLoader)classLoaderToUse).getOrDefault(factoryTypeName, Collections.emptyList());
    }

    private static Map<String, List<String>> loadSpringFactories(ClassLoader classLoader) {
        HashMap<String, List<String>> result = (HashMap<String, List<String>>)cache.get(classLoader);
        if (result != null) {
            return result;
        }
        result = new HashMap<String, List<String>>();
        try {
            Enumeration<URL> urls = classLoader.getResources("META-INF/spring.factories");
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                UrlResource resource = new UrlResource(url);
                Properties properties = PropertiesLoaderUtils.loadProperties((Resource)resource);
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    String[] factoryImplementationNames;
                    String factoryTypeName = ((String)entry.getKey()).trim();
                    for (String factoryImplementationName : factoryImplementationNames = StringUtils.commaDelimitedListToStringArray((String)((String)entry.getValue()))) {
                        result.computeIfAbsent(factoryTypeName, key -> new ArrayList()).add(factoryImplementationName.trim());
                    }
                }
            }
            result.replaceAll((factoryType, implementations) -> implementations.stream().distinct().collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList)));
            cache.put(classLoader, result);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Unable to load factories from location [META-INF/spring.factories]", ex);
        }
        return result;
    }

    private static <T> T instantiateFactory(String factoryImplementationName, Class<T> factoryType, ClassLoader classLoader) {
        try {
            Class factoryImplementationClass = ClassUtils.forName((String)factoryImplementationName, (ClassLoader)classLoader);
            if (!factoryType.isAssignableFrom(factoryImplementationClass)) {
                throw new IllegalArgumentException("Class [" + factoryImplementationName + "] is not assignable to factory type [" + factoryType.getName() + "]");
            }
            return ReflectionUtils.accessibleConstructor((Class)factoryImplementationClass, (Class[])new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException("Unable to instantiate factory class [" + factoryImplementationName + "] for factory type [" + factoryType.getName() + "]", ex);
        }
    }
}

