/*
 * Decompiled with CFR 0.152.
 */
package cn.dustlight.flow.application.controllers;

import cn.dustlight.auth.client.reactive.ReactiveAuthClient;
import cn.dustlight.auth.resources.AuthPrincipalUtil;
import cn.dustlight.auth.resources.core.AuthPrincipal;
import cn.dustlight.flow.core.flow.QueryResult;
import cn.dustlight.flow.core.flow.usertask.UserTask;
import cn.dustlight.flow.core.flow.usertask.UserTaskService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/v1"})
@SecurityRequirement(name="auth")
@Tag(name="UserTasks", description="\u7528\u6237\u4efb\u52a1")
@CrossOrigin
public class UserTaskController {
    @Autowired
    private UserTaskService userTaskService;

    @Operation(summary="\u83b7\u53d6\u7528\u6237\u4efb\u52a1")
    @GetMapping(value={"/task/{id}"})
    public Mono<UserTask> getUserTask(@PathVariable(name="id") Long id, @RequestParam(name="cid", required=false) String clientId, ReactiveAuthClient reactiveAuthClient, AuthPrincipal principal) {
        return AuthPrincipalUtil.obtainClientId((ReactiveAuthClient)reactiveAuthClient, (String)clientId, (AuthPrincipal)principal).flatMap(cid -> this.userTaskService.getTask(cid, id));
    }

    @Operation(summary="\u83b7\u53d6\u7528\u6237\u4efb\u52a1")
    @GetMapping(value={"/tasks"})
    public Mono<QueryResult<UserTask>> getUserTasks(@RequestParam(name="status", required=false) UserTaskService.TaskStatus status, @RequestParam(name="page", required=false, defaultValue="0") int page, @RequestParam(name="size", required=false, defaultValue="10") int size, @RequestParam(name="cid", required=false) String clientId, ReactiveAuthClient reactiveAuthClient, AuthPrincipal principal) {
        return AuthPrincipalUtil.obtainClientId((ReactiveAuthClient)reactiveAuthClient, (String)clientId, (AuthPrincipal)principal).flatMap(cid -> this.userTaskService.getTasks(cid, Set.of(principal.getUidString()), UserTaskController.getRoles((AuthPrincipal)principal), status, page, size));
    }

    @Operation(summary="\u5b8c\u6210\u7528\u6237\u4efb\u52a1")
    @PostMapping(value={"/task/{id}/completion"})
    public Mono<Void> completeUserTask(@PathVariable(name="id") Long id, @RequestBody Map<String, Object> data, @RequestParam(name="cid", required=false) String clientId, ReactiveAuthClient reactiveAuthClient, AuthPrincipal principal) {
        return AuthPrincipalUtil.obtainClientId((ReactiveAuthClient)reactiveAuthClient, (String)clientId, (AuthPrincipal)principal).flatMap(cid -> this.userTaskService.complete(cid, id, principal.getUidString(), data));
    }

    public static Collection<String> getRoles(AuthPrincipal principal) {
        Collection authorities;
        if (principal == null || (authorities = principal.getAuthorities()) == null || authorities.size() == 0) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (String authority : authorities) {
            if (!authority.startsWith("ROLE_")) continue;
            result.add(authority.substring("ROLE_".length()));
        }
        return result;
    }
}

