/*
 * Decompiled with CFR 0.152.
 */
package cn.dustlight.flow.application.controllers;

import cn.dustlight.auth.client.reactive.ReactiveAuthClient;
import cn.dustlight.auth.resources.AuthPrincipalUtil;
import cn.dustlight.auth.resources.core.AuthPrincipal;
import cn.dustlight.flow.core.exceptions.ErrorEnum;
import cn.dustlight.flow.core.flow.process.ProcessService;
import cn.dustlight.flow.core.flow.trigger.FlowTrigger;
import cn.dustlight.flow.core.flow.trigger.TriggerStore;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/v1"})
@SecurityRequirement(name="auth")
@Tag(name="Triggers", description="\u89e6\u53d1\u5668\u76f8\u5173")
@CrossOrigin
public class TriggerController {
    @Autowired
    private TriggerStore triggerStore;
    @Autowired
    private FlowTrigger trigger;
    @Autowired
    private ProcessService processService;

    @Operation(summary="\u8bbe\u7f6e\u89e6\u53d1\u5668")
    @PutMapping(value={"/trigger/{key}"})
    public Mono<Void> setTriggerProcess(@PathVariable(name="key") String key, @RequestParam(name="opt") String operation, @RequestBody Set<String> processes, @RequestParam(name="cid", required=false) String clientId, AuthPrincipal principal, ReactiveAuthClient client) {
        if (!this.trigger.getSupportOperations().contains(operation)) {
            return Mono.error((Throwable)ErrorEnum.TRIGGER_OPERATION_NOT_FOUND.getException());
        }
        return AuthPrincipalUtil.obtainClientId((ReactiveAuthClient)client, (String)clientId, (AuthPrincipal)principal).flatMap(cid -> processes != null && processes.size() > 0 ? this.processService.isProcessExists(cid, (Collection)processes).flatMap(flag -> (Boolean)flag != false ? this.triggerStore.setSubscription(cid, key, operation, processes) : Mono.error((Throwable)ErrorEnum.PROCESS_NOT_FOUND.getException())) : this.triggerStore.setSubscription(cid, key, operation, Collections.emptySet()));
    }

    @Operation(summary="\u83b7\u53d6\u89e6\u53d1\u5668\u7684\u76ee\u6807\u6d41\u7a0b")
    @GetMapping(value={"/trigger/{key}"})
    public Mono<Collection<String>> getTriggerProcess(@PathVariable(name="key") String key, @RequestParam(name="opt", required=false) String operation, @RequestParam(name="cid", required=false) String clientId, AuthPrincipal principal, ReactiveAuthClient client) {
        if (!StringUtils.hasText((String)operation)) {
            operation = null;
        }
        if (StringUtils.hasText((String)operation) && !this.trigger.getSupportOperations().contains(operation)) {
            return Mono.error((Throwable)ErrorEnum.TRIGGER_OPERATION_NOT_FOUND.getException());
        }
        String finalOperation = operation;
        return AuthPrincipalUtil.obtainClientId((ReactiveAuthClient)client, (String)clientId, (AuthPrincipal)principal).flatMap(cid -> this.triggerStore.getProcess(cid, key, finalOperation).collectList());
    }

    @Operation(summary="\u83b7\u53d6\u6d41\u7a0b\u5173\u8054\u7684\u89e6\u53d1\u5668")
    @GetMapping(value={"/process/{process}/trigger"})
    public Mono<Collection<String>> getTriggerKeys(@PathVariable(name="process") String process, @RequestParam(name="opt", required=false) String operation, @RequestParam(name="cid", required=false) String clientId, AuthPrincipal principal, ReactiveAuthClient client) {
        if (!StringUtils.hasText((String)operation)) {
            operation = null;
        }
        if (StringUtils.hasText((String)operation) && !this.trigger.getSupportOperations().contains(operation)) {
            return Mono.error((Throwable)ErrorEnum.TRIGGER_OPERATION_NOT_FOUND.getException());
        }
        String finalOperation = operation;
        return AuthPrincipalUtil.obtainClientId((ReactiveAuthClient)client, (String)clientId, (AuthPrincipal)principal).flatMap(cid -> this.triggerStore.getSubscription(cid, process, finalOperation).collectList());
    }

    @Operation(summary="\u83b7\u53d6\u89e6\u53d1\u5668\u652f\u6301\u7684\u4e8b\u4ef6")
    @GetMapping(value={"/trigger-operations"})
    public Mono<Collection<String>> getOperations() {
        return Mono.just((Object)this.trigger.getSupportOperations());
    }
}

