/*
 * Decompiled with CFR 0.152.
 */
package cn.dustlight.flow.application.controllers;

import cn.dustlight.auth.client.reactive.ReactiveAuthClient;
import cn.dustlight.auth.resources.AuthPrincipalUtil;
import cn.dustlight.auth.resources.core.AuthPrincipal;
import cn.dustlight.flow.core.flow.QueryResult;
import cn.dustlight.flow.core.flow.process.Process;
import cn.dustlight.flow.core.flow.process.ProcessService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/v1"})
@SecurityRequirement(name="auth")
@Tag(name="Processes", description="\u6d41\u7a0b\u8d44\u6e90")
@CrossOrigin
public class ProcessController {
    @Autowired
    private ProcessService processService;

    @Operation(summary="\u521b\u5efa\u6d41\u7a0b")
    @PostMapping(value={"/process"}, consumes={"application/xml", "text/plain; charset: utf-8", "text/xml; charset: utf-8"}, produces={"application/json"})
    public Mono<Void> createProcess(@RequestParam(name="cid", required=false) String clientId, @RequestParam(name="base64", required=false, defaultValue="false") boolean isBase64, @RequestBody String data, ReactiveAuthClient reactiveAuthClient, AuthPrincipal principal) {
        return AuthPrincipalUtil.obtainClientId((ReactiveAuthClient)reactiveAuthClient, (String)clientId, (AuthPrincipal)principal).flatMap(cid -> this.processService.createProcess(cid, principal.getUidString(), (Object)(isBase64 ? data : Base64.getEncoder().encodeToString(data.getBytes(StandardCharsets.UTF_8))))).then();
    }

    @Operation(summary="\u901a\u8fc7\u540d\u79f0\u83b7\u53d6\u6d41\u7a0b")
    @GetMapping(value={"/process/{name}"})
    public Mono<Process> getProcess(@PathVariable String name, @RequestParam(name="cid", required=false) String clientId, ReactiveAuthClient reactiveAuthClient, AuthPrincipal principal) {
        return AuthPrincipalUtil.obtainClientId((ReactiveAuthClient)reactiveAuthClient, (String)clientId, (AuthPrincipal)principal).flatMap(cid -> this.processService.getProcess(cid, name, null));
    }

    @Operation(summary="\u901a\u8fc7\u540d\u79f0\u4e0e\u7248\u672c\u53f7\u83b7\u53d6\u6d41\u7a0b")
    @GetMapping(value={"/process/{name}/{version}"})
    public Mono<Process> getProcess(@PathVariable String name, @PathVariable Integer version, @RequestParam(name="cid", required=false) String clientId, ReactiveAuthClient reactiveAuthClient, AuthPrincipal principal) {
        return AuthPrincipalUtil.obtainClientId((ReactiveAuthClient)reactiveAuthClient, (String)clientId, (AuthPrincipal)principal).flatMap(cid -> this.processService.getProcess(cid, name, version));
    }

    @Operation(summary="\u83b7\u53d6\u6d41\u7a0b\u5217\u8868")
    @GetMapping(value={"/processes"})
    public Mono<QueryResult<Process>> getProcesses(@RequestParam(name="q", required=false) String keyword, @RequestParam(name="cid", required=false) String clientId, @RequestParam(name="page", required=false, defaultValue="0") int page, @RequestParam(name="size", required=false, defaultValue="10") int size, ReactiveAuthClient reactiveAuthClient, AuthPrincipal principal) {
        return AuthPrincipalUtil.obtainClientId((ReactiveAuthClient)reactiveAuthClient, (String)clientId, (AuthPrincipal)principal).flatMap(cid -> this.processService.findProcess(cid, keyword, page, size));
    }
}

