/*
 * Decompiled with CFR 0.152.
 */
package cn.dustlight.flow.application.controllers;

import cn.dustlight.auth.client.reactive.ReactiveAuthClient;
import cn.dustlight.auth.resources.AuthPrincipalUtil;
import cn.dustlight.auth.resources.core.AuthPrincipal;
import cn.dustlight.flow.core.flow.message.MessageService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/v1"})
@SecurityRequirement(name="auth")
@Tag(name="Messages", description="\u6d88\u606f\u8d44\u6e90")
@CrossOrigin
public class MessageController {
    @Autowired
    private MessageService messageService;

    @Operation(summary="\u53d1\u5e03\u6d88\u606f")
    @PostMapping(value={"/message"})
    public Mono<Void> createMessage(@RequestParam(name="name") String name, @RequestParam(name="key") String key, @RequestParam(name="cid", required=false) String clientId, ReactiveAuthClient reactiveAuthClient, AuthPrincipal principal) {
        return AuthPrincipalUtil.obtainClientId((ReactiveAuthClient)reactiveAuthClient, (String)clientId, (AuthPrincipal)principal).flatMap(cid -> this.messageService.publishMessage(cid, name, key)).then();
    }
}

