/*
 * Decompiled with CFR 0.152.
 */
package cn.dustlight.flow.application.controllers;

import cn.dustlight.auth.client.reactive.ReactiveAuthClient;
import cn.dustlight.auth.resources.AuthPrincipalUtil;
import cn.dustlight.auth.resources.core.AuthPrincipal;
import cn.dustlight.flow.core.flow.QueryResult;
import cn.dustlight.flow.core.flow.instance.Instance;
import cn.dustlight.flow.core.flow.instance.InstanceEvent;
import cn.dustlight.flow.core.flow.instance.InstanceService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/v1"})
@SecurityRequirement(name="auth")
@Tag(name="Instances", description="\u6d41\u7a0b\u5b9e\u4f8b\u8d44\u6e90")
@CrossOrigin
public class InstanceController {
    @Autowired
    private InstanceService instanceService;

    @Operation(summary="\u521b\u5efa\u6d41\u7a0b\u5b9e\u4f8b")
    @PostMapping(value={"/instance"})
    public Mono<Instance> createInstance(@RequestParam(name="name") String name, @RequestParam(name="cid", required=false) String clientId, @RequestBody Map<String, Object> variables, ReactiveAuthClient reactiveAuthClient, AuthPrincipal principal) {
        return AuthPrincipalUtil.obtainClientId((ReactiveAuthClient)reactiveAuthClient, (String)clientId, (AuthPrincipal)principal).flatMap(cid -> this.instanceService.start(cid, name, variables));
    }

    @Operation(summary="\u67e5\u8be2\u6d41\u7a0b\u5b9e\u4f8b")
    @GetMapping(value={"/instances"})
    public Mono<QueryResult<Instance>> getInstances(@RequestParam(name="name", required=false) String name, @RequestParam(name="version", required=false) Integer version, @RequestParam(name="status", required=false) Set<InstanceEvent.Status> status, @RequestParam(name="page", required=false, defaultValue="0") int page, @RequestParam(name="size", required=false, defaultValue="10") int size, @RequestParam(name="cid", required=false) String clientId, ReactiveAuthClient reactiveAuthClient, AuthPrincipal principal) {
        return AuthPrincipalUtil.obtainClientId((ReactiveAuthClient)reactiveAuthClient, (String)clientId, (AuthPrincipal)principal).flatMap(cid -> this.instanceService.list(cid, name, version, status, page, size));
    }

    @Operation(summary="\u901a\u8fc7 ID \u83b7\u53d6\u6d41\u7a0b\u5b9e\u4f8b")
    @GetMapping(value={"/instance/{id}"})
    public Mono<Instance> getInstance(@PathVariable Long id, @RequestParam(name="cid", required=false) String clientId, ReactiveAuthClient reactiveAuthClient, AuthPrincipal principal) {
        return AuthPrincipalUtil.obtainClientId((ReactiveAuthClient)reactiveAuthClient, (String)clientId, (AuthPrincipal)principal).flatMap(cid -> this.instanceService.get(cid, id));
    }

    @Operation(summary="\u901a\u8fc7 ID \u53d6\u6d88\u8fd0\u884c\u5b9e\u4f8b")
    @DeleteMapping(value={"/instance/{id}"})
    public Mono<Void> cancelInstance(@PathVariable Long id, @RequestParam(name="cid", required=false) String clientId, ReactiveAuthClient reactiveAuthClient, AuthPrincipal principal) {
        return AuthPrincipalUtil.obtainClientId((ReactiveAuthClient)reactiveAuthClient, (String)clientId, (AuthPrincipal)principal).flatMap(cid -> this.instanceService.cancel(cid, id));
    }

    @Operation(summary="\u83b7\u53d6\u5b9e\u4f8b\u53d8\u91cf")
    @GetMapping(value={"/instance/{id}/variables/{scope}"})
    public Mono<Map<String, Object>> getInstanceVariables(@PathVariable Long id, @PathVariable Long scope, @RequestParam(name="cid", required=false) String clientId, ReactiveAuthClient reactiveAuthClient, AuthPrincipal principal) {
        return AuthPrincipalUtil.obtainClientId((ReactiveAuthClient)reactiveAuthClient, (String)clientId, (AuthPrincipal)principal).flatMap(cid -> this.instanceService.getVariables(cid, id, scope));
    }

    @Operation(summary="\u901a\u8fc7 ID \u91cd\u8bd5\u5b9e\u4f8b")
    @PostMapping(value={"/instance/{id}/resolve/{scope}"})
    public Mono<Void> resolve(@PathVariable Long id, @PathVariable Long scope, @RequestParam(name="cid", required=false) String clientId, ReactiveAuthClient reactiveAuthClient, AuthPrincipal principal) {
        return AuthPrincipalUtil.obtainClientId((ReactiveAuthClient)reactiveAuthClient, (String)clientId, (AuthPrincipal)principal).flatMap(cid -> this.instanceService.resolve(cid, id, scope));
    }

    @Operation(summary="\u8bbe\u7f6e\u5b9e\u4f8b\u53d8\u91cf")
    @PutMapping(value={"/instance/{id}/variables/{scope}"})
    public Mono<Void> setInstanceVariables(@PathVariable Long id, @PathVariable Long scope, @RequestParam(name="cid", required=false) String clientId, @RequestBody Map<String, Object> variables, ReactiveAuthClient reactiveAuthClient, AuthPrincipal principal) {
        return AuthPrincipalUtil.obtainClientId((ReactiveAuthClient)reactiveAuthClient, (String)clientId, (AuthPrincipal)principal).flatMap(cid -> this.instanceService.setVariables(cid, id, scope, variables));
    }
}

