/*
 * Decompiled with CFR 0.152.
 */
package cn.dustlight.flow.application.controllers;

import cn.dustlight.flow.core.exceptions.ErrorDetails;
import cn.dustlight.flow.core.exceptions.ErrorEnum;
import cn.dustlight.flow.core.exceptions.FlowException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@RestControllerAdvice
@CrossOrigin
public class ExceptionController {
    protected final Log logger = LogFactory.getLog(this.getClass());

    @ExceptionHandler(value={Throwable.class})
    public Mono<ErrorDetails> onException(Throwable e, ServerWebExchange exchange) {
        ServerHttpResponse response = exchange.getResponse();
        ServerHttpRequest request = exchange.getRequest();
        response.setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
        this.logger.error((Object)String.format("Error on path: %s, remote ip: %s", request.getURI(), request.getRemoteAddress()), e);
        return Mono.just((Object)(this.logger.isDebugEnabled() ? ErrorEnum.UNKNOWN.details(e.getMessage()) : ErrorEnum.UNKNOWN.getDetails()));
    }

    @ExceptionHandler(value={FlowException.class})
    public Mono<ErrorDetails> onErrorException(FlowException e, ServerWebExchange exchange) {
        int code;
        ServerHttpResponse response = exchange.getResponse();
        ServerHttpRequest request = exchange.getRequest();
        int n = code = e != null && e.getErrorDetails() != null ? e.getErrorDetails().getCode() : 0;
        if (code == -1) {
            response.setStatusCode(HttpStatus.OK);
        } else if (code == 1) {
            response.setStatusCode(HttpStatus.UNAUTHORIZED);
        } else if (code == 2) {
            response.setStatusCode(HttpStatus.FORBIDDEN);
        } else if (code >= 2000 && code <= 2999) {
            response.setStatusCode(HttpStatus.NOT_FOUND);
        } else if (code >= 3000 && code <= 3999) {
            response.setStatusCode(HttpStatus.CONFLICT);
        } else {
            response.setStatusCode(HttpStatus.BAD_REQUEST);
        }
        this.logger.debug((Object)e.getErrorDetails().getMessage(), (Throwable)e);
        return Mono.just((Object)e.getErrorDetails());
    }

    @ExceptionHandler(value={AuthenticationException.class})
    public Mono<ErrorDetails> onAuthenticationException(AuthenticationException e, ServerWebExchange exchange) {
        ServerHttpResponse response = exchange.getResponse();
        ServerHttpRequest request = exchange.getRequest();
        response.setStatusCode(HttpStatus.FORBIDDEN);
        this.logger.debug((Object)e.getMessage(), (Throwable)e);
        return Mono.just((Object)ErrorEnum.UNAUTHORIZED.details(e.getMessage()));
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    public Mono<ErrorDetails> onAccessDeniedException(AccessDeniedException e, ServerWebExchange exchange) {
        ServerHttpResponse response = exchange.getResponse();
        ServerHttpRequest request = exchange.getRequest();
        response.setStatusCode(HttpStatus.FORBIDDEN);
        this.logger.debug((Object)e.getMessage(), (Throwable)e);
        return Mono.just((Object)ErrorEnum.ACCESS_DENIED.details(e.getMessage()));
    }
}

