/*
 * Decompiled with CFR 0.152.
 */
package cn.dustlight.flow.datacenter;

import cn.dustlight.flow.core.flow.trigger.FlowTrigger;
import cn.dustlight.flow.core.security.AccessTokenHolder;
import cn.dustlight.flow.datacenter.DatacenterRecordValidator;
import cn.dustlight.flow.datacenter.DatacenterWatcher;
import cn.dustlight.flow.datacenter.FlowDatacenterProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={FlowDatacenterProperties.class})
public class FlowDatacenterConfiguration {
    @Bean
    @ConditionalOnBean(value={FlowTrigger.class})
    public DatacenterWatcher datacenterWatcher(@Autowired FlowTrigger flowTrigger) {
        return new DatacenterWatcher(flowTrigger);
    }

    @Bean
    @ConditionalOnBean(value={AccessTokenHolder.class})
    public DatacenterRecordValidator datacenterRecordValidator(@Autowired AccessTokenHolder accessTokenHolder, @Autowired FlowDatacenterProperties properties, @Autowired ObjectMapper mapper) {
        return new DatacenterRecordValidator(properties.getEndpoint(), accessTokenHolder, mapper);
    }
}

